/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.azure.storage.queue.it;

import com.azure.core.http.policy.HttpLogDetailLevel;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.util.BinaryData;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.queue.QueueServiceClient;
import com.azure.storage.queue.QueueServiceClientBuilder;
import com.azure.storage.queue.models.PeekedMessageItem;
import com.azure.storage.queue.models.QueueItem;
import com.azure.storage.queue.models.QueueMessageItem;
import com.azure.storage.queue.models.QueuesSegmentOptions;
import java.net.URI;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.azure.storage.queue.QueueOperationDefinition;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.quarkus.component.azure.storage.queue.it.model.ExampleMessage;
import org.apache.camel.spi.RouteController;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Path(value="/azure-storage-queue")
@ApplicationScoped
public class AzureStorageQueueResource {
    protected static final String QUEUE_NAME = "camel-quarkus-" + UUID.randomUUID().toString();
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    CamelContext context;
    @ConfigProperty(name="azure.storage.account-name")
    String azureStorageAccountName;
    @ConfigProperty(name="azure.storage.account-key")
    String azureStorageAccountKey;
    @ConfigProperty(name="azure.queue.service.url")
    String azureQueueServiceUrl;

    @Produces
    public QueueServiceClient createQueueClient() throws Exception {
        StorageSharedKeyCredential credentials = new StorageSharedKeyCredential(this.azureStorageAccountName, this.azureStorageAccountKey);
        return new QueueServiceClientBuilder().endpoint(this.azureQueueServiceUrl).credential(credentials).httpLogOptions(new HttpLogOptions().setLogLevel(HttpLogDetailLevel.BODY_AND_HEADERS).setPrettyPrintBody(true)).buildClient();
    }

    @Path(value="/queue/create")
    @POST
    public Response createQueue() throws Exception {
        this.producerTemplate.sendBody(this.componentUri(QueueOperationDefinition.createQueue), null);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @Path(value="/queue/read")
    @GET
    @javax.ws.rs.Produces(value={"application/json"})
    public List<ExampleMessage> retrieveMessage() throws Exception {
        List messages = (List)this.producerTemplate.requestBody(this.componentUri(QueueOperationDefinition.receiveMessages), null, List.class);
        return messages.stream().map(this::createMessage).collect(Collectors.toList());
    }

    @Path(value="/queue/peek")
    @GET
    @javax.ws.rs.Produces(value={"text/plain"})
    public String peekOneMessage() throws Exception {
        List messages = (List)this.producerTemplate.requestBodyAndHeader(this.componentUri(QueueOperationDefinition.peekMessages), null, "CamelAzureStorageQueueMaxMessages", (Object)1, List.class);
        return messages.stream().map(PeekedMessageItem::getBody).map(BinaryData::toString).collect(Collectors.joining("\n"));
    }

    @Path(value="/queue/message")
    @POST
    @Consumes(value={"text/plain"})
    public Response addMessage(String message) throws Exception {
        this.producerTemplate.sendBody(this.componentUri(QueueOperationDefinition.sendMessage), (Object)message);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @Path(value="/queue/list")
    @GET
    @javax.ws.rs.Produces(value={"text/plain"})
    public String listQueues() throws Exception {
        QueuesSegmentOptions queuesSegmentOptions = new QueuesSegmentOptions();
        queuesSegmentOptions.setIncludeMetadata(true);
        List messages = (List)this.producerTemplate.requestBodyAndHeader(this.componentUri(QueueOperationDefinition.listQueues), null, "CamelAzureStorageQueueSegmentOptions", (Object)queuesSegmentOptions, List.class);
        return messages.stream().map(QueueItem::getName).collect(Collectors.joining("\n"));
    }

    @Path(value="/queue/delete")
    @DELETE
    public Response deleteQueue() throws Exception {
        this.producerTemplate.sendBody(this.componentUri(QueueOperationDefinition.deleteQueue), null);
        return Response.noContent().build();
    }

    @Path(value="/queue/delete/{id}/{popReceipt}")
    @DELETE
    public Response deleteMessageById(@PathParam(value="id") String id, @PathParam(value="popReceipt") String popReceipt) throws Exception {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("CamelAzureStorageQueueMessageId", id);
        headers.put("CamelAzureStorageQueuePopReceipt", popReceipt);
        headers.put("CamelAzureStorageQueueVisibilityTimeout", Duration.ofMillis(10L));
        this.producerTemplate.sendBodyAndHeaders(this.componentUri(QueueOperationDefinition.deleteMessage), null, headers);
        return Response.noContent().build();
    }

    @Path(value="/queue/update/{id}/{popReceipt}")
    @POST
    @Consumes(value={"text/plain"})
    public Response addMessage(@PathParam(value="id") String id, @PathParam(value="popReceipt") String popReceipt, String message) throws Exception {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("CamelAzureStorageQueueMessageId", id);
        headers.put("CamelAzureStorageQueuePopReceipt", popReceipt);
        headers.put("CamelAzureStorageQueueVisibilityTimeout", Duration.ofMillis(10L));
        this.producerTemplate.sendBodyAndHeaders(this.componentUri(QueueOperationDefinition.updateMessage), (Object)message, headers);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @Path(value="/queue/clear")
    @GET
    public Response clearQueue() throws Exception {
        this.producerTemplate.sendBody(this.componentUri(QueueOperationDefinition.clearQueue), null);
        return Response.noContent().build();
    }

    @Path(value="/queue/consumer/{action}")
    @POST
    public Response modifyConsumerRouteState(@PathParam(value="action") String action) throws Exception {
        RouteController controller = this.context.getRouteController();
        if (action.equals("start")) {
            controller.startRoute("queueRoute");
        } else if (action.equals("stop")) {
            controller.stopRoute("queueRoute");
        } else {
            throw new IllegalArgumentException("Unknown action: " + action);
        }
        return Response.noContent().build();
    }

    @Path(value="/queue/consumer")
    @GET
    @javax.ws.rs.Produces(value={"application/json"})
    public String receiveMessages() throws Exception {
        MockEndpoint mockEndpoint = (MockEndpoint)this.context.getEndpoint("mock:result", MockEndpoint.class);
        return mockEndpoint.getReceivedExchanges().stream().map(Exchange::getMessage).map(m -> (String)m.getBody(String.class)).collect(Collectors.joining("\n"));
    }

    private String componentUri(QueueOperationDefinition operation) {
        return String.format("azure-storage-queue://%s/%s?operation=%s", this.azureStorageAccountName, QUEUE_NAME, operation.name());
    }

    private ExampleMessage createMessage(QueueMessageItem messageItem) {
        ExampleMessage message = new ExampleMessage();
        BinaryData binaryData = messageItem.getBody();
        message.setBody(binaryData == null ? null : binaryData.toString());
        message.setId(messageItem.getMessageId());
        message.setPopReceipt(messageItem.getPopReceipt());
        return message;
    }
}

