/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.azure.storage.blob.it;

import java.util.function.BooleanSupplier;
import org.apache.camel.quarkus.test.mock.backend.MockBackendUtils;
import org.eclipse.microprofile.config.ConfigProvider;

public class AzureStorageHelper {
    private static final BooleanSupplier clientSecretAuthEnabled = new ClientSecretAuthEnabled();
    private static final BooleanSupplier clientCertificateAuthEnabled = new ClientCertificateAuthEnabled();

    private AzureStorageHelper() {
    }

    public static boolean isClientSecretAuthEnabled() {
        return clientSecretAuthEnabled.getAsBoolean();
    }

    public static boolean isClientCertificateAuthEnabled() {
        return clientCertificateAuthEnabled.getAsBoolean();
    }

    private static boolean isAzureConfigValuePresent(String name) {
        return ConfigProvider.getConfig().getOptionalValue(name, String.class).isPresent();
    }

    public static class ClientSecretAuthEnabled
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return !MockBackendUtils.startMockBackend() && AzureStorageHelper.isAzureConfigValuePresent("azure.client.id") && AzureStorageHelper.isAzureConfigValuePresent("azure.tenant.id") && AzureStorageHelper.isAzureConfigValuePresent("azure.client.secret");
        }
    }

    public static class ClientCertificateAuthEnabled
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return !MockBackendUtils.startMockBackend() && AzureStorageHelper.isAzureConfigValuePresent("azure.client.id") && AzureStorageHelper.isAzureConfigValuePresent("azure.tenant.id") && AzureStorageHelper.isAzureConfigValuePresent("azure.client.certificate.path");
        }
    }
}

