/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.sqs.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.ExtractableResponse;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.camel.quarkus.test.support.aws2.Aws2LocalStack;
import org.apache.camel.quarkus.test.support.aws2.Aws2TestResource;
import org.apache.camel.quarkus.test.support.aws2.BaseAWs2TestSupport;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.config.ConfigProvider;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=Aws2TestResource.class)
class Aws2SqsTest
extends BaseAWs2TestSupport {
    private static final Logger LOG = Logger.getLogger(Aws2SqsTest.class);
    @Aws2LocalStack
    private boolean localStack;

    public Aws2SqsTest() {
        super("/aws2-sqs");
    }

    private String getPredefinedQueueName() {
        return (String)ConfigProvider.getConfig().getValue("aws-sqs.queue-name", String.class);
    }

    private String getPredefinedFailingQueueName() {
        return (String)ConfigProvider.getConfig().getValue("aws-sqs.failing-name", String.class);
    }

    private String getPredefinedDeadletterQueueName() {
        return (String)ConfigProvider.getConfig().getValue("aws-sqs.deadletter-name", String.class);
    }

    private String getDelayedQueueName() {
        return (String)ConfigProvider.getConfig().getValue("aws-sqs.delayed-name", String.class);
    }

    private Integer getPollIntervalSendToDelayQueueInSecs() {
        return ConfigProvider.getConfig().getOptionalValue("aws-sqs.delayed-queue.poll-interval-secs", Integer.class).orElse(10);
    }

    private Integer getTimeoutSendToDelayQueueInMins() {
        return ConfigProvider.getConfig().getOptionalValue("aws-sqs.delayed-queue.timeout-mins", Integer.class).orElse(5);
    }

    @AfterEach
    void purgeQueueAndWait() {
        String qName = this.getPredefinedQueueName();
        this.purgeQueue(qName);
        try {
            if (!this.localStack) {
                TimeUnit.SECONDS.sleep(60L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((Object)this.receiveMessageFromQueue(qName, false), (Object)"");
    }

    private void purgeQueue(String queueName) {
        ((ValidatableResponse)RestAssured.delete((String)("/aws2-sqs/purge/queue/" + queueName), (Object[])new Object[0]).then()).statusCode(200);
    }

    @Test
    void sqs() {
        String queueName = this.getPredefinedQueueName();
        String[] queues = this.listQueues();
        Assertions.assertTrue((boolean)Stream.of(queues).anyMatch(url -> url.contains(queueName)));
        String msg = this.sendSingleMessageToQueue(queueName);
        this.awaitMessageWithExpectedContentFromQueue(msg, queueName);
    }

    private String[] listQueues() {
        return (String[])((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/aws2-sqs/queues", (Object[])new Object[0]).then()).statusCode(200)).extract().body().as(String[].class);
    }

    @Test
    void deadletter() {
        String failingQueueName = this.getPredefinedFailingQueueName();
        String deadletterQueueName = this.getPredefinedDeadletterQueueName();
        String[] queues = this.listQueues();
        Assertions.assertTrue((boolean)Stream.of(queues).anyMatch(url -> url.contains(failingQueueName)));
        String msg = this.sendSingleMessageToQueue(failingQueueName);
        this.awaitMessageWithExpectedContentFromQueue(msg, deadletterQueueName);
    }

    @Test
    void sqsDeleteMessage() {
        String qName = this.getPredefinedQueueName();
        this.sendSingleMessageToQueue(qName);
        String receipt = this.receiveReceiptOfMessageFromQueue(qName);
        String msg = this.sendSingleMessageToQueue(qName);
        this.deleteMessageFromQueue(qName, receipt);
        this.awaitMessageWithExpectedContentFromQueue(msg, qName);
        this.awaitMessageWithExpectedContentFromQueue(msg, qName);
    }

    private String sendSingleMessageToQueue(String queueName) {
        String msg = "sqs" + UUID.randomUUID().toString().replace("-", "");
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/aws2-sqs/send/" + queueName, new Object[0])).then()).statusCode(201);
        return msg;
    }

    private String receiveReceiptOfMessageFromQueue(String queueName) {
        return ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/aws2-sqs/receive/receipt/" + queueName), (Object[])new Object[0]).then()).statusCode(200)).extract().body().asString();
    }

    private void deleteMessageFromQueue(String queueName, String receipt) {
        ((ValidatableResponse)RestAssured.delete((String)("/aws2-sqs/delete/message/" + queueName + "/" + URLEncoder.encode(receipt, StandardCharsets.UTF_8)), (Object[])new Object[0]).then()).statusCode(200);
    }

    @Test
    void sqsAutoCreateDelayedQueue() {
        String qName = this.getDelayedQueueName();
        int delay = 20;
        try {
            String msg = "sqs" + UUID.randomUUID().toString().replace("-", "");
            Instant start = Instant.now();
            ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/aws2-sqs/queue/autocreate/delayed/" + qName + "/20/" + msg), (Object[])new Object[0]).then()).statusCode(200)).body(Matchers.equalTo((Object)msg), new Matcher[0]);
            this.awaitMessageWithExpectedContentFromQueue(msg, qName);
            Assertions.assertTrue((Duration.between(start, Instant.now()).getSeconds() >= 20L ? 1 : 0) != 0);
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).printStackTrace();
            Assertions.fail();
        }
    }

    private String createDelayQueueAndVerifyExistence(String queueName, int delay) {
        return ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/aws2-sqs/queue/autocreate/delayed/" + queueName + "/" + delay), (Object[])new Object[0]).then()).statusCode(200)).extract().body().asString();
    }

    private void awaitMessageWithExpectedContentFromQueue(String expectedContent, String queueName) {
        Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
            ExtractableResponse resp = ((ValidatableResponse)RestAssured.get((String)("/aws2-sqs/receive/" + queueName + "/false"), (Object[])new Object[0]).then()).extract();
            return resp.statusCode() == 200 && expectedContent.equals(resp.body().asString());
        });
    }

    private void deleteQueue(String queueName) {
        ((ValidatableResponse)RestAssured.delete((String)("/aws2-sqs/delete/queue/" + queueName), (Object[])new Object[0]).then()).statusCode(200);
        this.awaitQueueDeleted(queueName);
    }

    private void awaitQueueDeleted(String queueName) {
        Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> Stream.of(this.listQueues()).noneMatch(url -> url.contains(queueName)));
    }

    private String receiveMessageFromQueue(String queueName, boolean deleteMessage) {
        return ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/aws2-sqs/receive/" + queueName + "/" + deleteMessage), (Object[])new Object[0]).then()).statusCode((Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)200), (Matcher)Matchers.is((Object)204)))).extract().body().asString();
    }

    @Test
    void sqsSendBatchMessage() {
        ArrayList<String> messages = new ArrayList<String>(Arrays.asList("Hello from camel-quarkus", "This is a batch message test", "Let's add few more messages", "Next message will be last", "Goodbye from camel-quarkus"));
        Assertions.assertEquals((int)messages.size(), (int)this.sendMessageBatchAndRetrieveSuccessCount(messages));
    }

    private int sendMessageBatchAndRetrieveSuccessCount(List<String> batch) {
        return Integer.parseInt(((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(batch).post("/aws2-sqs/batch", new Object[0])).then()).statusCode(201)).extract().body().asString());
    }

    public void testMethodForDefaultCredentialsProvider() {
        this.listQueues();
    }
}

