/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.sqs.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.test.support.aws2.BaseAws2Resource;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import software.amazon.awssdk.services.sqs.model.ListQueuesResponse;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchResponse;

@Path(value="/aws2-sqs")
@ApplicationScoped
public class Aws2SqsResource
extends BaseAws2Resource {
    @ConfigProperty(name="aws-sqs.queue-name")
    String queueName;
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;

    public Aws2SqsResource() {
        super("sqs");
    }

    @Path(value="send")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response sqsSend(String message) throws Exception {
        String response = (String)this.producerTemplate.requestBody(this.componentUri(), (Object)message, String.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }

    @Path(value="send/{queueName}")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response sqsSendToSpecificQueue(@PathParam(value="queueName") String queueName, String message) throws Exception {
        String response = (String)this.producerTemplate.requestBody(this.componentUri(queueName), (Object)message, String.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }

    @Path(value="purge/queue/{queueName}")
    @DELETE
    @Produces(value={"text/plain"})
    public Response purgeQueue(@PathParam(value="queueName") String queueName) throws Exception {
        this.producerTemplate.sendBody(this.componentUri(queueName) + "&operation=purgeQueue", null);
        return Response.ok().build();
    }

    @Path(value="receive/{queueName}/{deleteMessage}")
    @GET
    @Produces(value={"text/plain"})
    public String sqsReceive(@PathParam(value="queueName") String queueName, @PathParam(value="deleteMessage") String deleteMessage) throws Exception {
        return (String)this.consumerTemplate.receiveBody(this.componentUri(queueName) + "&deleteAfterRead=" + deleteMessage + "&deleteIfFiltered=" + deleteMessage + "&defaultVisibilityTimeout=0", 10000L, String.class);
    }

    @Path(value="receive/receipt/{queueName}")
    @GET
    @Produces(value={"text/plain"})
    public String sqsReceipt(@PathParam(value="queueName") String queueName) throws Exception {
        return this.consumerTemplate.receive(this.componentUri(queueName), 10000L).getIn().getHeader("CamelAwsSqsReceiptHandle").toString();
    }

    @Path(value="queues")
    @GET
    @Produces(value={"application/json"})
    public List<String> listQueues() throws Exception {
        return ((ListQueuesResponse)this.producerTemplate.requestBody(this.componentUri() + "&operation=listQueues", null, ListQueuesResponse.class)).queueUrls();
    }

    @Path(value="batch")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response sendBatchMessage(List<String> messages) throws Exception {
        SendMessageBatchResponse response = (SendMessageBatchResponse)this.producerTemplate.requestBody(this.componentUri() + "&operation=sendBatchMessage", messages, SendMessageBatchResponse.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)("" + response.successful().size())).build();
    }

    @Path(value="delete/message/{queueName}/{receipt}")
    @DELETE
    @Produces(value={"text/plain"})
    public Response deleteMessage(@PathParam(value="queueName") String queueName, @PathParam(value="receipt") String receipt) throws Exception {
        this.producerTemplate.sendBodyAndHeader(this.componentUri(queueName) + "&operation=deleteMessage", null, "CamelAwsSqsReceiptHandle", (Object)URLDecoder.decode(receipt, StandardCharsets.UTF_8));
        return Response.ok().build();
    }

    @Path(value="delete/queue/{queueName}")
    @DELETE
    @Produces(value={"text/plain"})
    public Response deleteQueue(@PathParam(value="queueName") String queueName) throws Exception {
        this.producerTemplate.sendBody(this.componentUri(queueName) + "&operation=deleteQueue", null);
        return Response.ok().build();
    }

    @Path(value="queue/autocreate/delayed/{queueName}/{delay}/{msg}")
    @GET
    @Produces(value={"text/plain"})
    public String autoCreateDelayedQueue(@PathParam(value="queueName") String queueName, @PathParam(value="delay") String delay, @PathParam(value="msg") String msg) {
        String uri = String.format("aws2-sqs://%s?autoCreateQueue=true&delayQueue=true&delaySeconds=%s", queueName, delay);
        return (String)this.producerTemplate.requestBody(uri, (Object)msg, String.class);
    }

    private String componentUri() {
        return this.componentUri(this.queueName);
    }

    private String componentUri(String queueName) {
        return "aws2-sqs://" + queueName + "?useDefaultCredentialsProvider=" + this.isUseDefaultCredentials();
    }
}

