/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.sqs.it;

import java.util.Locale;
import org.apache.camel.quarkus.test.support.aws2.Aws2TestEnvContext;
import org.apache.camel.quarkus.test.support.aws2.Aws2TestEnvCustomizer;
import org.apache.commons.lang3.RandomStringUtils;
import org.testcontainers.containers.localstack.LocalStackContainer;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.CreateQueueRequest;
import software.amazon.awssdk.services.sqs.model.DeleteQueueRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueUrlRequest;
import software.amazon.awssdk.services.sqs.model.QueueDoesNotExistException;

public class Aws2SqsTestEnvCustomizer
implements Aws2TestEnvCustomizer {
    public LocalStackContainer.Service[] localstackServices() {
        return new LocalStackContainer.Service[]{LocalStackContainer.Service.SQS};
    }

    public void customize(Aws2TestEnvContext envContext) {
        String queueName = "camel-quarkus-" + RandomStringUtils.randomAlphanumeric((int)49).toLowerCase(Locale.ROOT);
        envContext.property("aws-sqs.queue-name", queueName);
        String failingQueueName = "camel-quarkus-failing-" + RandomStringUtils.randomAlphanumeric((int)49).toLowerCase(Locale.ROOT);
        envContext.property("aws-sqs.failing-name", failingQueueName);
        String deadletterQueueName = "camel-quarkus-dead-letter-" + RandomStringUtils.randomAlphanumeric((int)49).toLowerCase(Locale.ROOT);
        envContext.property("aws-sqs.deadletter-name", deadletterQueueName);
        String delayedQueueName = "camel-quarkus-delayed-" + RandomStringUtils.randomAlphanumeric((int)49).toLowerCase(Locale.ROOT);
        envContext.property("aws-sqs.delayed-name", delayedQueueName);
        SqsClient sqsClient = (SqsClient)envContext.client(LocalStackContainer.Service.SQS, SqsClient::builder);
        String queueUrl = sqsClient.createQueue((CreateQueueRequest)CreateQueueRequest.builder().queueName(queueName).build()).queueUrl();
        String failingUrl = sqsClient.createQueue((CreateQueueRequest)CreateQueueRequest.builder().queueName(failingQueueName).build()).queueUrl();
        String deadletterUrl = sqsClient.createQueue((CreateQueueRequest)CreateQueueRequest.builder().queueName(deadletterQueueName).build()).queueUrl();
        envContext.closeable(() -> {
            sqsClient.deleteQueue((DeleteQueueRequest)DeleteQueueRequest.builder().queueUrl(queueUrl).build());
            sqsClient.deleteQueue((DeleteQueueRequest)DeleteQueueRequest.builder().queueUrl(failingUrl).build());
            sqsClient.deleteQueue((DeleteQueueRequest)DeleteQueueRequest.builder().queueUrl(deadletterUrl).build());
            try {
                String url = sqsClient.getQueueUrl((GetQueueUrlRequest)GetQueueUrlRequest.builder().queueName(delayedQueueName).build()).queueUrl();
                sqsClient.deleteQueue((DeleteQueueRequest)DeleteQueueRequest.builder().queueUrl(url).build());
            }
            catch (QueueDoesNotExistException queueDoesNotExistException) {
                // empty catch block
            }
        });
    }
}

