/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.sns.it;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.camel.quarkus.test.support.aws2.Aws2TestEnvContext;
import org.apache.camel.quarkus.test.support.aws2.Aws2TestEnvCustomizer;
import org.apache.commons.lang3.RandomStringUtils;
import org.testcontainers.containers.localstack.LocalStackContainer;
import software.amazon.awssdk.services.sns.SnsClient;
import software.amazon.awssdk.services.sns.model.CreateTopicRequest;
import software.amazon.awssdk.services.sns.model.DeleteTopicRequest;
import software.amazon.awssdk.services.sns.model.ListSubscriptionsByTopicRequest;
import software.amazon.awssdk.services.sns.model.Subscription;
import software.amazon.awssdk.services.sns.model.UnsubscribeRequest;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.CreateQueueRequest;
import software.amazon.awssdk.services.sqs.model.DeleteQueueRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesRequest;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;
import software.amazon.awssdk.services.sqs.model.SetQueueAttributesRequest;

public class Aws2SqsSnsTestEnvCustomizer
implements Aws2TestEnvCustomizer {
    public LocalStackContainer.Service[] localstackServices() {
        return new LocalStackContainer.Service[]{LocalStackContainer.Service.SQS, LocalStackContainer.Service.SNS};
    }

    public void customize(Aws2TestEnvContext envContext) {
        String queueName = "camel-quarkus-" + RandomStringUtils.randomAlphanumeric((int)49).toLowerCase(Locale.ROOT);
        envContext.property("aws-sqs.queue-name", queueName);
        SqsClient sqsClient = (SqsClient)envContext.client(LocalStackContainer.Service.SQS, SqsClient::builder);
        String queueUrl = sqsClient.createQueue((CreateQueueRequest)CreateQueueRequest.builder().queueName(queueName).attributes(Map.ofEntries(Map.entry(QueueAttributeName.VISIBILITY_TIMEOUT, "0"))).build()).queueUrl();
        envContext.closeable(() -> sqsClient.deleteQueue((DeleteQueueRequest)DeleteQueueRequest.builder().queueUrl(queueUrl).build()));
        this.customizeSns(envContext, sqsClient, false);
        this.customizeSns(envContext, sqsClient, true);
    }

    private void customizeSns(Aws2TestEnvContext envContext, SqsClient sqsClient, boolean fifo) {
        String topicName = "camel-quarkus-" + RandomStringUtils.randomAlphanumeric((int)49).toLowerCase(Locale.ROOT) + (fifo ? ".fifo" : "");
        envContext.property(fifo ? "aws-sns-fifo.topic-name" : "aws-sns.topic-name", topicName);
        SnsClient snsClient = (SnsClient)envContext.client(LocalStackContainer.Service.SNS, SnsClient::builder);
        CreateTopicRequest.Builder topicRequestBuilder = CreateTopicRequest.builder().name(topicName);
        if (fifo) {
            topicRequestBuilder.attributes(Collections.singletonMap("FifoTopic", Boolean.TRUE.toString()));
        }
        String topicArn = snsClient.createTopic((CreateTopicRequest)topicRequestBuilder.build()).topicArn();
        envContext.closeable(() -> {
            snsClient.listSubscriptionsByTopic((ListSubscriptionsByTopicRequest)ListSubscriptionsByTopicRequest.builder().topicArn(topicArn).build()).subscriptions().stream().map(Subscription::subscriptionArn).forEach(arn -> snsClient.unsubscribe((UnsubscribeRequest)UnsubscribeRequest.builder().subscriptionArn(arn).build()));
            snsClient.deleteTopic((DeleteTopicRequest)DeleteTopicRequest.builder().topicArn(topicArn).build());
        });
        String snsReceiverQueueName = "camel-quarkus-sns-receiver-" + RandomStringUtils.randomAlphanumeric((int)30).toLowerCase(Locale.ROOT) + (fifo ? ".fifo" : "");
        envContext.property(fifo ? "aws-sqs.sns-fifo-receiver-queue-name" : "aws-sqs.sns-receiver-queue-name", snsReceiverQueueName);
        CreateQueueRequest.Builder createQueueRequestBuilder = CreateQueueRequest.builder().queueName(snsReceiverQueueName);
        if (fifo) {
            createQueueRequestBuilder.attributes(Collections.singletonMap(QueueAttributeName.FIFO_QUEUE, Boolean.TRUE.toString()));
        }
        String snsReceiverQueueUrl = sqsClient.createQueue((CreateQueueRequest)createQueueRequestBuilder.build()).queueUrl();
        envContext.property(fifo ? "aws2-sqs.sns-fifo-receiver-queue-url" : "aws2-sqs.sns-receiver-queue-url", snsReceiverQueueUrl);
        String snsReceiverQueueArn = (String)sqsClient.getQueueAttributes((GetQueueAttributesRequest)GetQueueAttributesRequest.builder().queueUrl(snsReceiverQueueUrl).attributeNamesWithStrings(new String[]{"All"}).build()).attributesAsStrings().get("QueueArn");
        envContext.property(fifo ? "aws2-sqs.sns-fifo-receiver-queue-arn" : "aws2-sqs.sns-receiver-queue-arn", snsReceiverQueueArn);
        String policy = "{  \"Version\": \"2008-10-17\",  \"Id\": \"policy-" + snsReceiverQueueName + "\",  \"Statement\": [    {      \"Sid\": \"sid-" + snsReceiverQueueName + "\",      \"Effect\": \"Allow\",      \"Principal\": {        \"AWS\": \"*\"      },      \"Action\": \"SQS:*\",      \"Resource\": \"" + snsReceiverQueueArn + "\"    }  ]}";
        sqsClient.setQueueAttributes((SetQueueAttributesRequest)SetQueueAttributesRequest.builder().queueUrl(snsReceiverQueueUrl).attributes(Collections.singletonMap(QueueAttributeName.POLICY, policy)).build());
        envContext.closeable(() -> sqsClient.deleteQueue((DeleteQueueRequest)DeleteQueueRequest.builder().queueUrl(snsReceiverQueueUrl).build()));
    }
}

