/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.sns.it;

import java.net.URI;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Path(value="/aws2-sqs-sns")
@ApplicationScoped
public class Aws2SqsSnsResource {
    @ConfigProperty(name="aws-sqs.queue-name")
    String queueName;
    @ConfigProperty(name="aws-sqs.sns-receiver-queue-name")
    String snsReceiverQueueName;
    @ConfigProperty(name="aws2-sqs.sns-receiver-queue-arn")
    String snsReceiverQueueArn;
    @ConfigProperty(name="aws-sns.topic-name")
    String topicName;
    @ConfigProperty(name="aws-sqs.sns-fifo-receiver-queue-name")
    String snsFifoReceiverQueueName;
    @ConfigProperty(name="aws2-sqs.sns-fifo-receiver-queue-arn")
    String snsFifoReceiverQueueArn;
    @ConfigProperty(name="aws-sns-fifo.topic-name")
    String fifoTopicName;
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;

    @Path(value="/sqs/purge/queue/{queueName}")
    @DELETE
    @Produces(value={"text/plain"})
    public Response purgeQueue(@PathParam(value="queueName") String queueName) throws Exception {
        this.producerTemplate.sendBodyAndHeader(this.componentUri(queueName) + "?operation=purgeQueue", null, "CamelAwsSqsPrefix", (Object)queueName);
        return Response.ok().build();
    }

    @Path(value="/sns/send")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response snsSend(String message, @QueryParam(value="queueUrl") String queueUrl, @DefaultValue(value="false") @QueryParam(value="fifo") boolean fifo) throws Exception {
        String response = (String)this.producerTemplate.requestBody(String.format("aws2-sns://%s?subscribeSNStoSQS=true&queueUrl=RAW(%s)%s", fifo ? this.fifoTopicName : this.topicName, fifo ? this.snsFifoReceiverQueueArn : this.snsReceiverQueueArn, fifo ? "&messageGroupIdStrategy=useExchangeId" : ""), (Object)message, String.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }

    @Path(value="/sqs/receive/{queueName}/{deleteMessage}")
    @GET
    @Produces(value={"text/plain"})
    public String sqsReceive(@PathParam(value="queueName") String queueName, @PathParam(value="deleteMessage") String deleteMessage) throws Exception {
        return (String)this.consumerTemplate.receiveBody(this.componentUri(queueName) + "?deleteAfterRead=" + deleteMessage + "&deleteIfFiltered=" + deleteMessage + "&defaultVisibilityTimeout=0", 10000L, String.class);
    }

    @Path(value="/sns/receiveViaSqs")
    @GET
    @Produces(value={"application/json"})
    public String sqsReceiveViaSqs() throws Exception {
        return (String)this.consumerTemplate.receiveBody("aws2-sqs://" + this.snsReceiverQueueName, 10000L, String.class);
    }

    @Path(value="/snsFifo/receiveViaSqs")
    @GET
    @Produces(value={"application/json"})
    public String fifoSqsReceiveViaSqs() throws Exception {
        return (String)this.consumerTemplate.receiveBody("aws2-sqs://" + this.snsFifoReceiverQueueName, 10000L, String.class);
    }

    private String componentUri(String queueName) {
        return "aws2-sqs://" + queueName;
    }
}

