/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.sns.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.camel.quarkus.test.support.aws2.Aws2LocalStack;
import org.apache.camel.quarkus.test.support.aws2.Aws2TestResource;
import org.eclipse.microprofile.config.ConfigProvider;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=Aws2TestResource.class)
class Aws2SqsSnsTest {
    @Aws2LocalStack
    private boolean localStack;

    Aws2SqsSnsTest() {
    }

    private String getPredefinedQueueName() {
        return (String)ConfigProvider.getConfig().getValue("aws-sqs.queue-name", String.class);
    }

    @AfterEach
    public void purgeQueueAndWait() {
        String qName = this.getPredefinedQueueName();
        this.purgeQueue(qName);
        try {
            if (!this.localStack) {
                TimeUnit.SECONDS.sleep(60L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assertions.assertEquals((Object)this.receiveMessageFromQueue(qName, false), (Object)"");
    }

    private void purgeQueue(String queueName) {
        ((ValidatableResponse)RestAssured.delete((String)("/aws2-sqs-sns/sqs/purge/queue/" + queueName), (Object[])new Object[0]).then()).statusCode(200);
    }

    private String receiveMessageFromQueue(String queueName, boolean deleteMessage) {
        return ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/aws2-sqs-sns/sqs/receive/" + queueName + "/" + deleteMessage), (Object[])new Object[0]).then()).statusCode((Matcher)CoreMatchers.anyOf((Matcher[])new Matcher[]{Is.is((Object)200), Is.is((Object)204)}))).extract().body().asString();
    }

    @Test
    void sns() {
        String snsMsg = "sns" + UUID.randomUUID().toString().replace("-", "");
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(snsMsg).post("/aws2-sqs-sns/sns/send", new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/aws2-sqs-sns/sns/receiveViaSqs", (Object[])new Object[0]).then()).statusCode(200)).body("Message", Is.is((Object)snsMsg), new Object[0]);
    }

    @Test
    void snsFifo() {
        String snsMsg = "snsFifo" + UUID.randomUUID().toString().replace("-", "");
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("fifo", new Object[]{true}).body(snsMsg).post("/aws2-sqs-sns/sns/send", new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/aws2-sqs-sns/snsFifo/receiveViaSqs", (Object[])new Object[0]).then()).statusCode(200)).body("Message", Is.is((Object)snsMsg), new Object[0]);
    }
}

