/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.sqs.it;

import java.net.URI;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import software.amazon.awssdk.services.sqs.model.ListQueuesResponse;

@Path(value="/aws2-sqs-sns")
@ApplicationScoped
public class Aws2SqsSnsResource {
    @ConfigProperty(name="aws-sqs.queue-name")
    String queueName;
    @ConfigProperty(name="aws-sqs.sns-receiver-queue-name")
    String snsReceiverQueueName;
    @ConfigProperty(name="aws2-sqs.sns-receiver-queue-arn")
    String snsReceiverQueueArn;
    @ConfigProperty(name="aws-sns.topic-name")
    String topicName;
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;

    @Path(value="/sqs/send")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response sqsSend(String message) throws Exception {
        String response = (String)this.producerTemplate.requestBody(this.componentUri(), (Object)message, String.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }

    @Path(value="/sqs/receive")
    @GET
    @Produces(value={"text/plain"})
    public String sqsReceive() throws Exception {
        return (String)this.consumerTemplate.receiveBody(this.componentUri(), 10000L, String.class);
    }

    @Path(value="/sqs/queues")
    @GET
    @Produces(value={"application/json"})
    public List<String> listQueues() throws Exception {
        return ((ListQueuesResponse)this.producerTemplate.requestBody(this.componentUri() + "?operation=listQueues", null, ListQueuesResponse.class)).queueUrls();
    }

    private String componentUri() {
        return "aws2-sqs://" + this.queueName;
    }

    @Path(value="/sns/send")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response snsSend(String message, @QueryParam(value="queueUrl") String queueUrl) throws Exception {
        String response = (String)this.producerTemplate.requestBody("aws2-sns://" + this.topicName + "?subscribeSNStoSQS=true&queueUrl=RAW(" + this.snsReceiverQueueArn + ")", (Object)message, String.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }

    @Path(value="/sns/receiveViaSqs")
    @GET
    @Produces(value={"application/json"})
    public String sqsReceiveViaSqs() throws Exception {
        return (String)this.consumerTemplate.receiveBody("aws2-sqs://" + this.snsReceiverQueueName, 10000L, String.class);
    }
}

