/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.ses.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.Collections;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.quarkus.test.support.aws2.BaseAws2Resource;
import org.jboss.logging.Logger;

@Path(value="/aws2-ses")
@ApplicationScoped
public class Aws2SesResource
extends BaseAws2Resource {
    private static final Logger LOG = Logger.getLogger(Aws2SesResource.class);
    @Inject
    FluentProducerTemplate producerTemplate;

    public Aws2SesResource() {
        super("ses");
    }

    @Path(value="/send")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response post(String message, @HeaderParam(value="x-from") String from, @HeaderParam(value="x-to") String to, @HeaderParam(value="x-subject") String subject, @HeaderParam(value="x-returnPath") String returnPath) throws Exception {
        Object response = this.producerTemplate.to("aws2-ses:" + from + "?useDefaultCredentialsProvider=" + this.isUseDefaultCredentials()).withHeader("CamelAwsSesTo", Collections.singletonList(to)).withHeader("CamelAwsSesSubject", (Object)subject).withHeader("CamelAwsSesReturnPath", (Object)returnPath).withBody((Object)message).request();
        LOG.debugf("Message sent: %s", response);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }
}

