/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.ses.it;

import java.net.URI;
import java.util.Collections;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.FluentProducerTemplate;
import org.jboss.logging.Logger;

@Path(value="/aws2-ses")
@ApplicationScoped
public class Aws2SesResource {
    private static final Logger LOG = Logger.getLogger(Aws2SesResource.class);
    @Inject
    FluentProducerTemplate producerTemplate;

    @Path(value="/send")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response post(String message, @HeaderParam(value="x-from") String from, @HeaderParam(value="x-to") String to, @HeaderParam(value="x-subject") String subject, @HeaderParam(value="x-returnPath") String returnPath) throws Exception {
        Object response = this.producerTemplate.to("aws2-ses:" + from).withHeader("CamelAwsSesTo", Collections.singletonList(to)).withHeader("CamelAwsSesSubject", (Object)subject).withHeader("CamelAwsSesReturnPath", (Object)returnPath).withBody((Object)message).request();
        LOG.debugf("Message sent: %s", response);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }
}

