/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.ses.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.path.json.JsonPath;
import io.restassured.response.ExtractableResponse;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.apache.camel.quarkus.test.support.aws2.Aws2Client;
import org.apache.camel.quarkus.test.support.aws2.Aws2TestResource;
import org.apache.commons.lang3.RandomStringUtils;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariables;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.testcontainers.containers.localstack.LocalStackContainer;
import software.amazon.awssdk.services.ses.SesClient;
import software.amazon.awssdk.services.ses.model.DeleteVerifiedEmailAddressRequest;
import software.amazon.awssdk.services.ses.model.VerifyEmailAddressRequest;

@EnabledIfEnvironmentVariables(value={@EnabledIfEnvironmentVariable(named="AWS_ACCESS_KEY", matches="[a-zA-Z0-9]+"), @EnabledIfEnvironmentVariable(named="MAILSLURP_API_KEY", matches="[a-zA-Z0-9]+")})
@QuarkusTest
@QuarkusTestResource(value=Aws2TestResource.class)
class Aws2SesTest {
    private static final Logger LOG = Logger.getLogger(Aws2SesTest.class);
    private static final Pattern VERIFCATION_LINK_PATTERN = Pattern.compile("https://email-verification[^\\s]+");
    @Aws2Client(value=LocalStackContainer.Service.SES)
    SesClient sesClient;

    Aws2SesTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws InterruptedException, ExecutionException, TimeoutException {
        Config config = ConfigProvider.getConfig();
        String mailSlurpApiKey = (String)config.getValue("mailslurp.api.key", String.class);
        JsonPath mailbox = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("x-api-key", (Object)mailSlurpApiKey, new Object[0]).post("https://api.mailslurp.com:443/createInbox", new Object[0])).then()).statusCode(201)).extract().body().jsonPath();
        String mailSlurpAddress = (String)mailbox.get("emailAddress");
        String mailboxId = (String)mailbox.get("id");
        LOG.infof("Using mailslurp inbox id: %s", (Object)mailboxId);
        try {
            this.sesClient.verifyEmailAddress((VerifyEmailAddressRequest)VerifyEmailAddressRequest.builder().emailAddress(mailSlurpAddress).build());
            List messageIds = (List)Awaitility.await().pollDelay(1L, TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
                ExtractableResponse response = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("x-api-key", (Object)mailSlurpApiKey, new Object[0]).get("https://api.mailslurp.com:443/inboxes/" + mailboxId + "/emails", new Object[0])).then()).statusCode(200)).extract();
                List ids = response.jsonPath().getList("id");
                LOG.infof("Expected an identity verification message from SES; got %s", (Object)response.body().asString());
                return ids;
            }, Matchers.not((Matcher)Matchers.empty()));
            boolean verified = false;
            for (String id : messageIds) {
                JsonPath email = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("x-api-key", (Object)mailSlurpApiKey, new Object[0]).get("https://api.mailslurp.com:443/emails/" + id, new Object[0])).then()).statusCode(200)).extract().body().jsonPath();
                String from = email.getString("from");
                String body = email.getString("body");
                LOG.debugf("Got e-mail from %s: %s", (Object)from, (Object)body);
                java.util.regex.Matcher m = VERIFCATION_LINK_PATTERN.matcher(body);
                if (!m.find()) continue;
                String link = m.group();
                LOG.infof("Found verification link %s", (Object)link);
                HtmlUnitDriver driver = new HtmlUnitDriver();
                driver.get(link);
                String source = driver.getPageSource();
                Assertions.assertThat((String)source).contains(new CharSequence[]{"You have successfully verified an email address"});
                verified = true;
                break;
            }
            Assertions.assertThat((boolean)verified).isTrue();
            String randomId = RandomStringUtils.randomAlphanumeric((int)16).toLowerCase(Locale.ROOT);
            String subject = "Test " + randomId;
            String body = "Hello " + randomId;
            LOG.infof("About to send message to %s with subject %s", (Object)mailSlurpAddress, (Object)subject);
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).header("x-from", (Object)mailSlurpAddress, new Object[0]).header("x-to", (Object)mailSlurpAddress, new Object[0]).header("x-subject", (Object)subject, new Object[0]).header("x-returnPath", (Object)mailSlurpAddress, new Object[0]).body(body).post("/aws2-ses/send", new Object[0])).then()).statusCode(201);
            Awaitility.await().pollDelay(1L, TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
                ExtractableResponse response = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().header("x-api-key", (Object)mailSlurpApiKey, new Object[0]).get("https://api.mailslurp.com:443/inboxes/" + mailboxId + "/emails", new Object[0])).then()).statusCode(200)).extract();
                List subjects = response.jsonPath().getList("subject");
                LOG.infof("Expected subject '%s'; got %s", (Object)subject, (Object)response.body().asString());
                return subjects;
            }, Matchers.hasItem((Object)subject));
        }
        finally {
            this.sesClient.deleteVerifiedEmailAddress((DeleteVerifiedEmailAddressRequest)DeleteVerifiedEmailAddressRequest.builder().emailAddress(mailSlurpAddress).build());
            ((ValidatableResponse)((Response)RestAssured.given().header("x-api-key", (Object)mailSlurpApiKey, new Object[0]).delete("https://api.mailslurp.com:443/inboxes/" + mailboxId, new Object[0])).then()).statusCode(204);
        }
    }
}

