/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.s3.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.camel.quarkus.test.support.aws2.Aws2TestResource;
import org.apache.camel.quarkus.test.support.aws2.BaseAWs2TestSupport;
import org.apache.commons.lang3.RandomStringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

@QuarkusTest
@QuarkusTestResource(value=Aws2TestResource.class)
class Aws2S3Test
extends BaseAWs2TestSupport {
    private int objects_num_before;
    private int objects_num_after;

    public Aws2S3Test() {
        super("/aws2-s3");
    }

    @BeforeEach
    public void before() {
        this.objects_num_before = this.getObjects().length;
    }

    @AfterEach
    public void after(TestInfo testInfo) {
        this.objects_num_after = this.getObjects().length;
        if (this.objects_num_after != this.objects_num_before) {
            Assertions.fail((String)("There is object leak after " + ((Method)testInfo.getTestMethod().get()).getName()));
        }
    }

    private String[] getObjects() {
        String[] objects = (String[])((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/aws2-s3/object-keys", new Object[0])).then()).statusCode(200)).extract().body().as(String[].class);
        return objects;
    }

    @Test
    public void crud() {
        String oid = UUID.randomUUID().toString();
        String blobContent = "Hello " + oid;
        String[] objects = (String[])((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/aws2-s3/object-keys", new Object[0])).then()).statusCode(200)).extract().body().as(String[].class);
        Assertions.assertTrue((boolean)Stream.of(objects).noneMatch(key -> key.equals(oid)));
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(blobContent).post("/aws2-s3/object/" + oid, new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/aws2-s3/object/" + oid), (Object[])new Object[0]).then()).statusCode(200)).body(Is.is((Object)blobContent), new Matcher[0]);
        String updatedContent = blobContent + " updated";
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(updatedContent).post("/aws2-s3/object/" + oid, new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/aws2-s3/object/" + oid), (Object[])new Object[0]).then()).statusCode(200)).body(Is.is((Object)updatedContent), new Matcher[0]);
        ((ValidatableResponse)RestAssured.delete((String)("/aws2-s3/object/" + oid), (Object[])new Object[0]).then()).statusCode(204);
    }

    @Test
    public void consumer() {
        String oid = UUID.randomUUID().toString();
        String blobContent = "Hello " + oid;
        String[] objects = (String[])((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/aws2-s3/object-keys", new Object[0])).then()).statusCode(200)).extract().body().as(String[].class);
        Assertions.assertTrue((boolean)Stream.of(objects).noneMatch(key -> key.equals(oid)));
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(blobContent).post("/aws2-s3/object/" + oid, new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/aws2-s3/poll-object/" + oid), (Object[])new Object[0]).then()).statusCode(200)).body(Is.is((Object)blobContent), new Matcher[0]);
        objects = (String[])((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/aws2-s3/object-keys", new Object[0])).then()).statusCode(200)).extract().body().as(String[].class);
        Assertions.assertTrue((boolean)Stream.of(objects).noneMatch(key -> key.equals(oid)));
    }

    @Test
    public void testKms() throws Exception {
        String oid = UUID.randomUUID().toString();
        String blobContent = "Hello KMS " + oid;
        try {
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(blobContent).post("/aws2-s3/object/" + oid + "?useKms=true", new Object[0])).then()).statusCode(201);
            ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/aws2-s3/object/" + oid + "?useKms=true"), (Object[])new Object[0]).then()).statusCode(200)).body(Is.is((Object)blobContent), new Matcher[0]);
        }
        finally {
            this.deleteObject(oid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void upload() throws Exception {
        String oid = UUID.randomUUID().toString();
        String content = RandomStringUtils.randomAlphabetic((int)0x800000);
        try {
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(content).post("/aws2-s3/upload/" + oid, new Object[0])).then()).statusCode(200);
            String result = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/aws2-s3/object/" + oid), (Object[])new Object[0]).then()).statusCode(200)).extract().asString();
            result = result.replaceAll("\\s*[0-9]+;chunk-signature=\\w{64}\\s*", "");
            Assertions.assertEquals((Object)content, (Object)result);
        }
        finally {
            this.deleteObject(oid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void copyObjectDeleteBucket() throws Exception {
        String[] buckets2;
        String oid1 = UUID.randomUUID().toString();
        String oid2 = UUID.randomUUID().toString();
        String blobContent = "Hello " + oid1;
        String destinationBucket = "camel-quarkus-copy-object-" + RandomStringUtils.randomAlphanumeric((int)32).toLowerCase(Locale.ROOT);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(blobContent).post("/aws2-s3/object/" + oid1, new Object[0])).then()).statusCode(201);
        try {
            this.autoCreateBucket(destinationBucket);
            buckets2 = this.getAllBuckets();
            Assertions.assertTrue((boolean)Stream.of(buckets2).anyMatch(key -> key.equals(destinationBucket)));
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.URLENC).formParam("dest_key", new Object[]{oid2}).formParam("dest_bucket", new Object[]{destinationBucket}).post("/aws2-s3/copy/" + oid1, new Object[0])).then()).statusCode(204);
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/aws2-s3/object/" + oid2 + "?bucket=" + destinationBucket, new Object[0])).then()).statusCode(200)).body(Is.is((Object)blobContent), new Matcher[0]);
        }
        finally {
            this.deleteObject(oid1);
            try {
                ((ValidatableResponse)RestAssured.delete((String)("/aws2-s3/bucket/" + destinationBucket + "/object/" + oid2), (Object[])new Object[0]).then()).statusCode(204);
            }
            catch (Exception buckets2) {}
            ((ValidatableResponse)RestAssured.delete((String)("/aws2-s3/bucket/" + destinationBucket), (Object[])new Object[0]).then()).statusCode(204);
            buckets2 = this.getAllBuckets();
            Assertions.assertTrue((boolean)Stream.of(buckets2).noneMatch(key -> key.equals(destinationBucket)));
        }
    }

    @Test
    void listBuckets() throws Exception {
        String[] buckets = this.getAllBuckets();
        Assertions.assertTrue((boolean)Stream.of(buckets).anyMatch(key -> key.startsWith("camel-quarkus")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void downloadLink() throws Exception {
        String oid = UUID.randomUUID().toString();
        String blobContent = "Hello " + oid;
        try {
            this.createObject(oid, blobContent);
            String downloadLink = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/aws2-s3/downloadlink/" + oid, new Object[0])).then()).statusCode(200)).extract().body().asString();
            URI downloadUri = new URI(downloadLink);
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().port(downloadUri.getPort()).get(URLDecoder.decode(downloadLink, StandardCharsets.UTF_8), new Object[0])).then()).statusCode(200)).body(Is.is((Object)blobContent), new Matcher[0]);
        }
        finally {
            this.deleteObject(oid);
        }
    }

    @Test
    public void objectRange() {
        String oid = UUID.randomUUID().toString();
        String blobContent = "Hello " + oid;
        try {
            this.createObject(oid, blobContent);
            ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).param("start", new Object[]{"0"}).param("end", new Object[]{"4"}).get("/aws2-s3/object/range/" + oid, new Object[0])).then()).statusCode(200)).body(Is.is((Object)"Hello"), new Matcher[0]);
        }
        finally {
            this.deleteObject(oid);
        }
    }

    private void createObject(String oid, String blobContent) {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(blobContent).post("/aws2-s3/object/" + oid, new Object[0])).then()).statusCode(201);
    }

    private void deleteObject(String oid) {
        ((ValidatableResponse)RestAssured.delete((String)("/aws2-s3/object/" + oid), (Object[])new Object[0]).then()).statusCode(204);
    }

    private void autoCreateBucket(String newBucketName) {
        ((ValidatableResponse)((Response)RestAssured.given().get("/aws2-s3/autoCreateBucket/" + newBucketName, new Object[0])).then()).statusCode(204);
    }

    private String[] getAllBuckets() {
        String[] buckets = (String[])((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/aws2-s3/bucket", new Object[0])).then()).statusCode(200)).extract().body().as(String[].class);
        return buckets;
    }

    public void testMethodForDefaultCredentialsProvider() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).get("/aws2-s3/bucket", new Object[0])).then()).statusCode(200);
    }
}

