/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.s3.it;

import java.util.Locale;
import org.apache.camel.quarkus.test.support.aws2.Aws2TestEnvContext;
import org.apache.camel.quarkus.test.support.aws2.Aws2TestEnvCustomizer;
import org.apache.commons.lang3.RandomStringUtils;
import org.testcontainers.containers.localstack.LocalStackContainer;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.model.CreateKeyRequest;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.DeleteBucketRequest;

public class Aws2S3TestEnvCustomizer
implements Aws2TestEnvCustomizer {
    public LocalStackContainer.Service[] localstackServices() {
        return new LocalStackContainer.Service[]{LocalStackContainer.Service.S3, LocalStackContainer.Service.KMS};
    }

    public void customize(Aws2TestEnvContext envContext) {
        S3Client s3Client = (S3Client)envContext.client(LocalStackContainer.Service.S3, S3Client::builder);
        KmsClient kmsClient = (KmsClient)envContext.client(LocalStackContainer.Service.KMS, KmsClient::builder);
        String bucketName = "camel-quarkus-" + RandomStringUtils.randomAlphanumeric((int)49).toLowerCase(Locale.ROOT);
        s3Client.createBucket((CreateBucketRequest)CreateBucketRequest.builder().bucket(bucketName).build());
        envContext.property("aws-s3.bucket-name", bucketName);
        envContext.closeable(() -> s3Client.deleteBucket((DeleteBucketRequest)DeleteBucketRequest.builder().bucket(bucketName).build()));
        if (envContext.isLocalStack()) {
            String kmsKeyId = kmsClient.createKey((CreateKeyRequest)CreateKeyRequest.builder().description("Test_key").build()).keyMetadata().keyId();
            envContext.property("aws-s3.kms-key-id", kmsKeyId);
        }
    }
}

