/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.camel.quarkus.test.support.aws2.Aws2TestResource;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=Aws2TestResource.class)
class Aws2S3Test {
    Aws2S3Test() {
    }

    @Test
    public void crud() {
        String oid = UUID.randomUUID().toString();
        String blobContent = "Hello " + oid;
        String[] objects = (String[])((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/aws2/s3/object-keys", new Object[0])).then()).statusCode(200)).extract().body().as(String[].class);
        Assertions.assertTrue((boolean)Stream.of(objects).noneMatch(key -> key.equals(oid)));
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(blobContent).post("/aws2/s3/object/" + oid, new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/aws2/s3/object/" + oid), (Object[])new Object[0]).then()).statusCode(200)).body(Is.is((Object)blobContent), new Matcher[0]);
        String updatedContent = blobContent + " updated";
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(updatedContent).post("/aws2/s3/object/" + oid, new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/aws2/s3/object/" + oid), (Object[])new Object[0]).then()).statusCode(200)).body(Is.is((Object)updatedContent), new Matcher[0]);
        ((ValidatableResponse)RestAssured.delete((String)("/aws2/s3/object/" + oid), (Object[])new Object[0]).then()).statusCode(204);
    }

    @Test
    public void consumer() {
        String oid = UUID.randomUUID().toString();
        String blobContent = "Hello " + oid;
        String[] objects = (String[])((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/aws2/s3/object-keys", new Object[0])).then()).statusCode(200)).extract().body().as(String[].class);
        Assertions.assertTrue((boolean)Stream.of(objects).noneMatch(key -> key.equals(oid)));
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(blobContent).post("/aws2/s3/object/" + oid, new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/aws2/s3/poll-object/" + oid), (Object[])new Object[0]).then()).statusCode(200)).body(Is.is((Object)blobContent), new Matcher[0]);
        objects = (String[])((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/aws2/s3/object-keys", new Object[0])).then()).statusCode(200)).extract().body().as(String[].class);
        Assertions.assertTrue((boolean)Stream.of(objects).noneMatch(key -> key.equals(oid)));
    }
}

