/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.lambda.it;

import java.net.URI;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.aws2.lambda.Lambda2Operations;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.lambda.model.AliasConfiguration;
import software.amazon.awssdk.services.lambda.model.CreateEventSourceMappingResponse;
import software.amazon.awssdk.services.lambda.model.EventSourceMappingConfiguration;
import software.amazon.awssdk.services.lambda.model.FunctionConfiguration;
import software.amazon.awssdk.services.lambda.model.GetAliasRequest;
import software.amazon.awssdk.services.lambda.model.GetAliasResponse;
import software.amazon.awssdk.services.lambda.model.GetFunctionResponse;
import software.amazon.awssdk.services.lambda.model.InvalidParameterValueException;
import software.amazon.awssdk.services.lambda.model.LastUpdateStatus;
import software.amazon.awssdk.services.lambda.model.ListAliasesRequest;
import software.amazon.awssdk.services.lambda.model.ListAliasesResponse;
import software.amazon.awssdk.services.lambda.model.ListEventSourceMappingsResponse;
import software.amazon.awssdk.services.lambda.model.ListFunctionsResponse;
import software.amazon.awssdk.services.lambda.model.ListTagsResponse;
import software.amazon.awssdk.services.lambda.model.ListVersionsByFunctionResponse;
import software.amazon.awssdk.services.lambda.model.Runtime;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeRequest;
import software.amazon.awssdk.services.lambda.model.UpdateFunctionCodeResponse;

@Path(value="/aws2-lambda")
@ApplicationScoped
public class Aws2LambdaResource {
    private static final Logger LOG = Logger.getLogger(Aws2LambdaResource.class);
    @ConfigProperty(name="aws-lambda.role-arn")
    String roleArn;
    @ConfigProperty(name="aws-lambda.event-source-arn")
    String eventSourceArn;
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/function/create/{functionName}")
    @POST
    @Consumes(value={"application/zip"})
    @Produces(value={"text/plain"})
    public Response createFunction(byte[] zipFunctionBytes, @PathParam(value="functionName") String functionName) throws Exception {
        String response = (String)this.producerTemplate.requestBodyAndHeaders(Aws2LambdaResource.componentUri(functionName, Lambda2Operations.createFunction), (Object)zipFunctionBytes, (Map)new LinkedHashMap<String, Object>(){
            {
                this.put("CamelAwsLambdaRole", Aws2LambdaResource.this.roleArn);
                this.put("CamelAwsLambdaRuntime", Runtime.PYTHON3_9);
                this.put("CamelAwsLambdaHandler", "index.handler");
            }
        }, String.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }

    @Path(value="/function/getState/{functionName}")
    @GET
    @Produces(value={"application/json"})
    public String getFunction(@PathParam(value="functionName") String functionName) {
        return ((GetFunctionResponse)this.producerTemplate.requestBody(Aws2LambdaResource.componentUri(functionName, Lambda2Operations.getFunction), null, GetFunctionResponse.class)).configuration().stateAsString();
    }

    @Path(value="/function/getArn/{functionName}")
    @GET
    @Produces(value={"application/json"})
    public String getFunctionArn(@PathParam(value="functionName") String functionName) {
        return ((GetFunctionResponse)this.producerTemplate.requestBody(Aws2LambdaResource.componentUri(functionName, Lambda2Operations.getFunction), null, GetFunctionResponse.class)).configuration().functionArn();
    }

    @Path(value="/function/update/{functionName}")
    @PUT
    @Consumes(value={"application/zip"})
    @Produces(value={"text/plain"})
    public Response updateFunction(byte[] zipFunctionBytes, @PathParam(value="functionName") String functionName) {
        UpdateFunctionCodeRequest ufcRequest;
        String uri = Aws2LambdaResource.componentUri(functionName, Lambda2Operations.updateFunction) + "&pojoRequest=true";
        UpdateFunctionCodeResponse ufcResponse = (UpdateFunctionCodeResponse)this.producerTemplate.requestBody(uri, (Object)(ufcRequest = (UpdateFunctionCodeRequest)UpdateFunctionCodeRequest.builder().functionName(functionName).zipFile(SdkBytes.fromByteArray((byte[])zipFunctionBytes)).build()), UpdateFunctionCodeResponse.class);
        if (ufcResponse.lastUpdateStatus() == LastUpdateStatus.SUCCESSFUL || ufcResponse.lastUpdateStatus() == LastUpdateStatus.IN_PROGRESS) {
            return Response.ok().build();
        }
        throw new IllegalStateException(ufcResponse.lastUpdateStatusReasonCodeAsString() + ": " + ufcResponse.lastUpdateStatusReason());
    }

    @Path(value="/function/list")
    @GET
    @Produces(value={"application/json"})
    public List<String> listFunctions() {
        return ((ListFunctionsResponse)this.producerTemplate.requestBody(Aws2LambdaResource.componentUri("foo", Lambda2Operations.listFunctions), null, ListFunctionsResponse.class)).functions().stream().map(FunctionConfiguration::functionName).collect(Collectors.toList());
    }

    @Path(value="/function/invoke/{functionName}")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public String invokeFunction(byte[] message, @PathParam(value="functionName") String functionName) {
        return (String)this.producerTemplate.requestBody(Aws2LambdaResource.componentUri(functionName, Lambda2Operations.invokeFunction), (Object)message, String.class);
    }

    @Path(value="/function/delete/{functionName}")
    @DELETE
    public void deleteFunction(@PathParam(value="functionName") String functionName) {
        this.producerTemplate.requestBody(Aws2LambdaResource.componentUri(functionName, Lambda2Operations.deleteFunction), null, Object.class);
    }

    @Path(value="/alias/create")
    @POST
    @Produces(value={"text/plain"})
    public Response createAlias(@QueryParam(value="functionName") String functionName, final @QueryParam(value="functionVersion") String functionVersion, final @QueryParam(value="aliasName") String aliasName) throws Exception {
        try {
            String response = (String)this.producerTemplate.requestBodyAndHeaders(Aws2LambdaResource.componentUri(functionName, Lambda2Operations.createAlias), null, (Map)new LinkedHashMap<String, Object>(){
                {
                    this.put("CamelAwsLambdaAliasFunctionName", aliasName);
                    this.put("CamelAwsLambdaFunctionVersion", functionVersion);
                }
            }, String.class);
            return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
        }
        catch (Exception e) {
            LOG.info((Object)"Exception caught in alias/create", (Throwable)e);
            LOG.info((Object)"Exception cause in alias/create", e.getCause());
            throw e;
        }
    }

    @Path(value="/alias/get")
    @GET
    @Produces(value={"text/plain"})
    public String getAlias(@QueryParam(value="functionName") String functionName, @QueryParam(value="aliasName") String aliasName) {
        try {
            GetAliasRequest getAliasRequest = (GetAliasRequest)GetAliasRequest.builder().functionName(functionName).name(aliasName).build();
            String endpointUri = Aws2LambdaResource.componentUri(functionName, Lambda2Operations.getAlias) + "&pojoRequest=true";
            return ((GetAliasResponse)this.producerTemplate.requestBody(endpointUri, (Object)getAliasRequest, GetAliasResponse.class)).functionVersion();
        }
        catch (Exception e) {
            LOG.info((Object)"Exception caught in alias/get", (Throwable)e);
            LOG.info((Object)"Exception cause in alias/get", e.getCause());
            throw e;
        }
    }

    @Path(value="/alias/delete")
    @DELETE
    public void deleteAlias(@QueryParam(value="functionName") String functionName, @QueryParam(value="aliasName") String aliasName) {
        try {
            this.producerTemplate.requestBodyAndHeader(Aws2LambdaResource.componentUri(functionName, Lambda2Operations.deleteAlias), null, "CamelAwsLambdaAliasFunctionName", (Object)aliasName, Object.class);
        }
        catch (Exception e) {
            LOG.info((Object)"Exception caught in alias/delete", (Throwable)e);
            LOG.info((Object)"Exception cause in alias/delete", e.getCause());
            throw e;
        }
    }

    @Path(value="/alias/list")
    @GET
    @Produces(value={"application/json"})
    public List<String> listAliases(@QueryParam(value="functionName") String functionName) {
        try {
            ListAliasesRequest listAliasesReq = (ListAliasesRequest)ListAliasesRequest.builder().functionName(functionName).build();
            return ((ListAliasesResponse)this.producerTemplate.requestBody(Aws2LambdaResource.componentUri(functionName, Lambda2Operations.listAliases) + "&pojoRequest=true", (Object)listAliasesReq, ListAliasesResponse.class)).aliases().stream().map(AliasConfiguration::name).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOG.info((Object)"Exception caught in alias/list", (Throwable)e);
            LOG.info((Object)"Exception cause in alias/list", e.getCause());
            throw e;
        }
    }

    @Path(value="/tag/create")
    @POST
    @Produces(value={"text/plain"})
    public Response tagLambdaFunction(final @QueryParam(value="functionArn") String functionArn, @QueryParam(value="tagResourceKey") String tagResourceKey, @QueryParam(value="tagResourceValue") String tagResourceValue) throws Exception {
        final Map<String, String> resourceTags = Map.of(tagResourceKey, tagResourceValue);
        String response = (String)this.producerTemplate.requestBodyAndHeaders(Aws2LambdaResource.componentUri(null, Lambda2Operations.tagResource), null, (Map)new LinkedHashMap<String, Object>(){
            {
                this.put("CamelAwsLambdaResourceArn", functionArn);
                this.put("CamelAwsLambdaResourceTags", resourceTags);
            }
        }, String.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }

    @Path(value="/tag/list")
    @GET
    @Produces(value={"application/json"})
    public Map<String, String> listLambdaFunctionTags(final @QueryParam(value="functionArn") String functionArn) {
        return ((ListTagsResponse)this.producerTemplate.requestBodyAndHeaders(Aws2LambdaResource.componentUri(null, Lambda2Operations.listTags), null, (Map)new LinkedHashMap<String, Object>(){
            {
                this.put("CamelAwsLambdaResourceArn", functionArn);
            }
        }, ListTagsResponse.class)).tags();
    }

    @Path(value="/tag/delete")
    @DELETE
    public void untagLambdaFunction(final @QueryParam(value="functionArn") String functionArn, final @QueryParam(value="tagResourceKey") String tagResourceKey) {
        this.producerTemplate.requestBodyAndHeaders(Aws2LambdaResource.componentUri(null, Lambda2Operations.untagResource), null, (Map)new LinkedHashMap<String, Object>(){
            {
                this.put("CamelAwsLambdaResourceArn", functionArn);
                this.put("CamelAwsLambdaResourceTagKeys", List.of(tagResourceKey));
            }
        });
    }

    @Path(value="/version/publish")
    @POST
    @Produces(value={"text/plain"})
    public Response publishVersion(@QueryParam(value="functionName") String functionName, @QueryParam(value="versionDescription") String versionDescription) throws Exception {
        String response = (String)this.producerTemplate.requestBody(Aws2LambdaResource.componentUri(functionName, Lambda2Operations.publishVersion), null, String.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }

    @Path(value="/version/list")
    @GET
    @Produces(value={"application/json"})
    public List<String> listVersions(@QueryParam(value="functionName") String functionName) {
        try {
            return ((ListVersionsByFunctionResponse)this.producerTemplate.requestBody(Aws2LambdaResource.componentUri(functionName, Lambda2Operations.listVersions), null, ListVersionsByFunctionResponse.class)).versions().stream().map(FunctionConfiguration::version).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOG.info((Object)"Exception caught in version/list", (Throwable)e);
            LOG.info((Object)"Exception cause in version/list", e.getCause());
            throw e;
        }
    }

    @Path(value="/event-source-mapping/create")
    @POST
    @Produces(value={"text/plain"})
    public Response createEventSourceMapping(@QueryParam(value="functionName") String functionName) throws Exception {
        try {
            CreateEventSourceMappingResponse response = (CreateEventSourceMappingResponse)this.producerTemplate.requestBodyAndHeader(Aws2LambdaResource.componentUri(functionName, Lambda2Operations.createEventSourceMapping), null, "CamelAwsLambdaEventSourceArn", (Object)this.eventSourceArn, CreateEventSourceMappingResponse.class);
            return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response.uuid()).build();
        }
        catch (Exception e) {
            LOG.info((Object)"Exception caught in event-source-mapping/create", (Throwable)e);
            LOG.info((Object)"Exception cause in event-source-mapping/create", e.getCause());
            throw e;
        }
    }

    @Path(value="/event-source-mapping/list")
    @GET
    @Produces(value={"application/json"})
    public Map<String, String> listEventSourceMappings(@QueryParam(value="functionName") String functionName) {
        try {
            ListEventSourceMappingsResponse response = (ListEventSourceMappingsResponse)this.producerTemplate.requestBody(Aws2LambdaResource.componentUri(functionName, Lambda2Operations.listEventSourceMapping), null, ListEventSourceMappingsResponse.class);
            return response.eventSourceMappings().stream().collect(Collectors.toMap(EventSourceMappingConfiguration::uuid, EventSourceMappingConfiguration::state));
        }
        catch (Exception e) {
            LOG.info((Object)"Exception caught in event-source-mapping/list", (Throwable)e);
            LOG.info((Object)"Exception cause in event-source-mapping/list", e.getCause());
            throw e;
        }
    }

    @Path(value="/event-source-mapping/delete")
    @DELETE
    public void deleteEventSourceMapping(@QueryParam(value="eventSourceMappingUuid") String eventSourceMappingUuid) {
        try {
            this.producerTemplate.requestBodyAndHeader(Aws2LambdaResource.componentUri(null, Lambda2Operations.deleteEventSourceMapping), null, "CamelAwsLambdaEventSourceUuid", (Object)eventSourceMappingUuid);
        }
        catch (Exception e) {
            LOG.info((Object)"Exception caught in event-source-mapping/delete", (Throwable)e);
            LOG.info((Object)"Exception cause in event-source-mapping/delete", e.getCause());
            throw e;
        }
    }

    private static String componentUri(String functionName, Lambda2Operations operation) {
        return "aws2-lambda:" + functionName + "?operation=" + operation;
    }

    @Provider
    public static class ExceptionMapper
    implements javax.ws.rs.ext.ExceptionMapper<CamelExecutionException> {
        public Response toResponse(CamelExecutionException exception) {
            if (exception.getCause() instanceof InvalidParameterValueException) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)exception.getCause().getMessage()).build();
            }
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exception.getMessage()).build();
        }
    }
}

