/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.kinesis.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.camel.quarkus.test.support.aws2.Aws2Client;
import org.apache.camel.quarkus.test.support.aws2.Aws2TestResource;
import org.apache.camel.quarkus.test.support.aws2.BaseAWs2TestSupport;
import org.apache.commons.lang3.RandomStringUtils;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Test;
import org.testcontainers.containers.localstack.LocalStackContainer;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsRequest;
import software.amazon.awssdk.services.s3.model.ListObjectsResponse;
import software.amazon.awssdk.services.s3.model.S3Object;

@QuarkusTest
@QuarkusTestResource(value=Aws2TestResource.class)
class Aws2KinesisFirehoseTest
extends BaseAWs2TestSupport {
    private static final Logger LOG = Logger.getLogger(Aws2KinesisFirehoseTest.class);
    @Aws2Client(value=LocalStackContainer.Service.S3)
    S3Client client;

    public Aws2KinesisFirehoseTest() {
        super("/aws2-kinesis-firehose");
    }

    @Test
    public void firehose() {
        String msg = RandomStringUtils.randomAlphanumeric((int)32768);
        String msgPrefix = msg.substring(0, 32);
        long maxDataBytes = 0x100000L;
        long bytesSent = 0L;
        LOG.info((Object)("Sending 1 MB of data to firehose using chunk " + msgPrefix + "..."));
        long deadline = System.currentTimeMillis() + 60000L;
        while (bytesSent < 0x100000L && System.currentTimeMillis() < deadline) {
            ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/aws2-kinesis-firehose/send", new Object[0])).then()).statusCode(201);
            LOG.info((Object)("Sent " + (bytesSent += (long)msg.length()) + "/1048576 bytes of data"));
        }
        LOG.info((Object)"Sent 1 MB of data to firehose");
        Config config = ConfigProvider.getConfig();
        String bucketName = (String)config.getValue("aws-kinesis.s3-bucket-name", String.class);
        LOG.infof("Bucket '%s' should contain objects.", (Object)bucketName);
        Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
            LOG.infof("Reading objects from bucket '%s'", (Object)bucketName);
            ListObjectsResponse objects = this.client.listObjects((ListObjectsRequest)ListObjectsRequest.builder().bucket(bucketName).build());
            List objs = objects.contents();
            LOG.info((Object)("There are  " + objs.size() + " objects in bucket " + bucketName));
            for (S3Object obj : objs) {
                LOG.info((Object)("Checking object " + obj.key() + " of size " + obj.size()));
                ResponseInputStream o = this.client.getObject((GetObjectRequest)GetObjectRequest.builder().bucket(bucketName).key(obj.key()).build());
                try {
                    int len;
                    StringBuilder sb = new StringBuilder(msg.length());
                    byte[] buf = new byte[1024];
                    while ((len = o.read(buf)) >= 0 && sb.length() < msgPrefix.length()) {
                        sb.append(new String(buf, 0, len, StandardCharsets.UTF_8));
                    }
                    String foundContent = sb.toString();
                    if (!foundContent.startsWith(msgPrefix)) continue;
                    LOG.info((Object)("Found the expected content in object " + obj.key()));
                    Boolean bl = true;
                    return bl;
                }
                finally {
                    if (o == null) continue;
                    o.close();
                }
            }
            return false;
        });
    }

    public void testMethodForDefaultCredentialsProvider() {
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("test").post("/aws2-kinesis-firehose/send", new Object[0])).then()).statusCode(201);
    }
}

