/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.kinesis.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.test.support.aws2.BaseAws2Resource;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Path(value="/aws2-kinesis-firehose")
@ApplicationScoped
public class Aws2KinesisFirehoseResource
extends BaseAws2Resource {
    @ConfigProperty(name="aws-kinesis-firehose.delivery-stream-name")
    String deliveryStreamName;
    @Inject
    ProducerTemplate producerTemplate;

    public Aws2KinesisFirehoseResource() {
        super("kinesis-firehose");
    }

    @Path(value="/send")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response send(String message) throws Exception {
        String response = (String)this.producerTemplate.requestBodyAndHeader(this.componentUri(), (Object)message, "CamelAwsKinesisPartitionKey", (Object)"foo-partition-key", String.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }

    private String componentUri() {
        return "aws2-kinesis-firehose://" + this.deliveryStreamName + "?useDefaultCredentialsProvider=" + this.isUseDefaultCredentials();
    }
}

