/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.kinesis.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.apache.camel.builder.RouteBuilder;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class Aws2KinesisRoutes
extends RouteBuilder {
    @ConfigProperty(name="aws-kinesis.stream-name")
    String streamName;
    @ConfigProperty(name="aws-kinesis.stream-name-for-default-credentials")
    String streamNameForDefaultCredentials;
    @Inject
    @Named(value="aws2KinesisMessages")
    Queue<String> aws2KinesisMessages;

    private String componentUri() {
        return "aws2-kinesis://" + this.streamName;
    }

    private String componentUriForDefaultCredentials() {
        return "aws2-kinesis://" + this.streamNameForDefaultCredentials;
    }

    public void configure() throws Exception {
        this.from(this.componentUri()).process(exchange -> this.aws2KinesisMessages.add((String)exchange.getMessage().getBody(String.class)));
        this.from(this.componentUriForDefaultCredentials()).process(exchange -> this.aws2KinesisMessages.add((String)exchange.getMessage().getBody(String.class)));
    }

    static class Producers {
        Producers() {
        }

        @Singleton
        @Produces
        @Named(value="aws2KinesisMessages")
        Queue<String> aws2KinesisMessages() {
            return new ConcurrentLinkedDeque<String>();
        }
    }
}

