/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.kinesis.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.camel.quarkus.test.support.aws2.Aws2Client;
import org.apache.camel.quarkus.test.support.aws2.Aws2TestResource;
import org.apache.camel.quarkus.test.support.aws2.BaseAWs2TestSupport;
import org.awaitility.Awaitility;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Test;
import org.testcontainers.containers.localstack.LocalStackContainer;
import software.amazon.awssdk.services.s3.S3Client;

@QuarkusTest
@QuarkusTestResource(value=Aws2TestResource.class)
class Aws2KinesisTest
extends BaseAWs2TestSupport {
    private static final Logger LOG = Logger.getLogger(Aws2KinesisTest.class);
    @Aws2Client(value=LocalStackContainer.Service.S3)
    S3Client client;

    public Aws2KinesisTest() {
        super("/aws2-kinesis");
    }

    @Test
    public void kinesis() {
        String msg = "kinesis-" + UUID.randomUUID().toString().replace("-", "");
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/aws2-kinesis/send", new Object[0])).then()).statusCode(201);
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).until(() -> ((ValidatableResponse)RestAssured.get((String)"/aws2-kinesis/receive", (Object[])new Object[0]).then()).extract(), response -> {
            int status = response.statusCode();
            String body = status == 200 ? response.body().asString() : null;
            LOG.info((Object)("Got " + status + " " + body));
            return response.statusCode() == 200 && msg.equals(body);
        });
    }

    public void testMethodForDefaultCredentialsProvider() {
        this.kinesis();
    }
}

