/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.kinesis.it;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.camel.builder.RouteBuilder;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@ApplicationScoped
public class Aws2KinesisRoutes
extends RouteBuilder {
    @ConfigProperty(name="aws-kinesis.stream-name")
    String streamName;
    @Inject
    @Named(value="aws2KinesisMessages")
    Queue<String> aws2KinesisMessages;

    private String componentUri() {
        return "aws2-kinesis://" + this.streamName;
    }

    public void configure() throws Exception {
        this.from(this.componentUri()).process(exchange -> this.aws2KinesisMessages.add((String)exchange.getMessage().getBody(String.class)));
    }

    static class Producers {
        Producers() {
        }

        @Singleton
        @Produces
        @Named(value="aws2KinesisMessages")
        Queue<String> aws2KinesisMessages() {
            return new ConcurrentLinkedDeque<String>();
        }
    }
}

