/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.kinesis.it;

import java.io.IOException;
import java.net.URI;
import java.util.Queue;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.ProducerTemplate;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@Path(value="/aws2-kinesis")
@ApplicationScoped
public class Aws2KinesisResource {
    private static final Logger log = Logger.getLogger(Aws2KinesisResource.class);
    @ConfigProperty(name="aws-kinesis.stream-name")
    String streamName;
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    @Named(value="aws2KinesisMessages")
    Queue<String> aws2KinesisMessages;

    @Path(value="/send")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response send(String message) throws Exception {
        String response = (String)this.producerTemplate.requestBodyAndHeader(this.componentUri(), (Object)message, "CamelAwsKinesisPartitionKey", (Object)"foo-partition-key", String.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }

    @Path(value="/receive")
    @GET
    @Produces(value={"text/plain"})
    public String receive() throws IOException {
        return this.aws2KinesisMessages.poll();
    }

    private String componentUri() {
        return "aws2-kinesis://" + this.streamName;
    }
}

