/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.kinesis.it;

import java.net.URI;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.ProducerTemplate;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Path(value="/aws2-kinesis-firehose")
@ApplicationScoped
public class Aws2KinesisFirehoseResource {
    @ConfigProperty(name="aws-kinesis-firehose.delivery-stream-name")
    String deliveryStreamName;
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/send")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response send(String message) throws Exception {
        String response = (String)this.producerTemplate.requestBodyAndHeader(this.componentUri(), (Object)message, "CamelAwsKinesisPartitionKey", (Object)"foo-partition-key", String.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }

    private String componentUri() {
        return "aws2-kinesis-firehose://" + this.deliveryStreamName;
    }
}

