/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.s3.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.aws2.s3.AWS2S3Operations;
import org.apache.camel.quarkus.test.support.aws2.BaseAws2Resource;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.NoSuchBucketException;
import software.amazon.awssdk.services.s3.model.S3Object;

@Path(value="/aws2-s3")
@ApplicationScoped
public class Aws2S3Resource
extends BaseAws2Resource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;
    @ConfigProperty(name="aws-s3.bucket-name")
    String bucketName;
    @ConfigProperty(name="aws-s3.kms-key-id")
    Optional<String> kmsKeyId;

    public Aws2S3Resource() {
        super("s3");
    }

    @Path(value="object/{key}")
    @POST
    @Consumes(value={"text/plain"})
    public Response post(String message, @PathParam(value="key") String key, @QueryParam(value="useKms") @DefaultValue(value="false") boolean useKms) throws Exception {
        this.producerTemplate.sendBodyAndHeader(this.componentUri() + (String)(useKms && this.kmsKeyId.isPresent() ? "&useAwsKMS=true&awsKMSKeyId=" + this.kmsKeyId : ""), (Object)message, "CamelAwsS3Key", (Object)key);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @Path(value="object/{key}")
    @GET
    @Produces(value={"text/plain"})
    public String get(@PathParam(value="key") String key, @QueryParam(value="bucket") String bucket, @QueryParam(value="useKms") @DefaultValue(value="false") boolean useKms) throws Exception {
        if (bucket == null) {
            bucket = this.bucketName;
        }
        return (String)this.producerTemplate.requestBodyAndHeader(this.componentUri(bucket, AWS2S3Operations.getObject) + (String)(useKms && this.kmsKeyId.isPresent() ? "&useAwsKMS=true&awsKMSKeyId=" + this.kmsKeyId : ""), null, "CamelAwsS3Key", (Object)key, String.class);
    }

    @Path(value="poll-object/{key}")
    @GET
    @Produces(value={"text/plain"})
    public String pollObject(@PathParam(value="key") String key) throws Exception {
        return (String)this.consumerTemplate.receiveBody(this.componentUri() + "&fileName=" + key, 10000L, String.class);
    }

    @Path(value="object/{key}")
    @DELETE
    @Produces(value={"text/plain"})
    public Response read(@PathParam(value="key") String key) throws Exception {
        this.producerTemplate.sendBodyAndHeader(this.componentUri(AWS2S3Operations.deleteObject), null, "CamelAwsS3Key", (Object)key);
        return Response.noContent().build();
    }

    @Path(value="bucket/{bucketName}/object/{key}")
    @DELETE
    @Produces(value={"text/plain"})
    public Response read(@PathParam(value="bucketName") String bucketName, @PathParam(value="key") String key) throws Exception {
        this.producerTemplate.sendBodyAndHeader(this.componentUri(bucketName, AWS2S3Operations.deleteObject), null, "CamelAwsS3Key", (Object)key);
        return Response.noContent().build();
    }

    @Path(value="object-keys")
    @GET
    @Produces(value={"application/json"})
    public List<String> objectKey() throws Exception {
        List objects = (List)this.producerTemplate.requestBody(this.componentUri(AWS2S3Operations.listObjects), null, List.class);
        return objects.stream().map(S3Object.class::cast).map(S3Object::key).collect(Collectors.toList());
    }

    @Path(value="autoCreateBucket/{newBucketName}")
    @GET
    @Produces(value={"application/json"})
    public Response autoCreateBucket(@PathParam(value="newBucketName") String newBucketName) {
        this.producerTemplate.sendBody(this.componentUri(newBucketName, AWS2S3Operations.listObjects) + "&autoCreateBucket=true", null);
        return Response.noContent().build();
    }

    @Path(value="upload/{key}")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public String upload(@PathParam(value="key") String key, String content) throws Exception {
        File file = File.createTempFile("aws2-", ".tmp");
        Files.writeString(file.toPath(), (CharSequence)content, StandardOpenOption.WRITE);
        int partSize = 0x500000;
        this.producerTemplate.sendBodyAndHeader(this.componentUri() + "&multiPartUpload=true&partSize=" + partSize + "&autoCreateBucket=true", (Object)file, "CamelAwsS3Key", (Object)key);
        return key;
    }

    @Path(value="copy/{key}")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    public Response copyObject(@PathParam(value="key") String key, @FormParam(value="dest_key") String dest_key, @FormParam(value="dest_bucket") String dest_bucket) {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put("CamelAwsS3Key", key);
        headers.put("CamelAwsS3DestinationKey", dest_key);
        headers.put("CamelAwsS3BucketDestinationName", dest_bucket);
        this.producerTemplate.sendBodyAndHeaders(this.componentUri(AWS2S3Operations.copyObject), null, headers);
        return Response.noContent().build();
    }

    @Path(value="bucket")
    @GET
    @Produces(value={"application/json"})
    public List<String> listBuckets() throws Exception {
        List buckets = (List)this.producerTemplate.requestBody(this.componentUri(AWS2S3Operations.listBuckets), null, List.class);
        return buckets.stream().map(Bucket.class::cast).map(Bucket::name).collect(Collectors.toList());
    }

    @Path(value="bucket/{name}")
    @DELETE
    @Produces(value={"text/plain"})
    public Response deleteBucket(@PathParam(value="name") String bucketName) {
        try {
            this.producerTemplate.sendBodyAndHeader(this.componentUri(bucketName, AWS2S3Operations.deleteBucket), null, "CamelAwsS3BucketName", (Object)bucketName);
        }
        catch (NoSuchBucketException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.noContent().build();
    }

    @Path(value="downloadlink/{key}")
    @GET
    @Produces(value={"text/plain"})
    public String downloadLink(@PathParam(value="key") String key, @QueryParam(value="bucket") String bucket) {
        if (bucket == null) {
            bucket = this.bucketName;
        }
        return (String)this.producerTemplate.requestBodyAndHeader(this.componentUri(bucket, AWS2S3Operations.createDownloadLink), null, "CamelAwsS3Key", (Object)key, String.class);
    }

    @Path(value="object/range/{key}")
    @GET
    @Produces(value={"text/plain"})
    public String objectRange(@PathParam(value="key") String key, @QueryParam(value="start") Integer start, @QueryParam(value="end") Integer end) throws Exception {
        LinkedHashMap<String, Object> headers = new LinkedHashMap<String, Object>();
        headers.put("CamelAwsS3Key", key);
        headers.put("CamelAwsS3RangeStart", start);
        headers.put("CamelAwsS3RangeEnd", end);
        ResponseInputStream s3Object = (ResponseInputStream)this.producerTemplate.requestBodyAndHeaders(this.componentUri(AWS2S3Operations.getObjectRange) + "&autoCreateBucket=false", null, headers, ResponseInputStream.class);
        StringBuilder textBuilder = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)s3Object, StandardCharsets.UTF_8));){
            int c = 0;
            while ((c = ((Reader)reader).read()) != -1) {
                textBuilder.append((char)c);
            }
        }
        return textBuilder.toString();
    }

    private String componentUri(String bucketName, AWS2S3Operations operation) {
        return String.format("aws2-s3://%s?operation=%s&useDefaultCredentialsProvider=%s", bucketName, operation, this.isUseDefaultCredentials());
    }

    private String componentUri(AWS2S3Operations operation) {
        return this.componentUri(this.bucketName, operation);
    }

    private String componentUri() {
        return String.format("aws2-s3://%s?useDefaultCredentialsProvider=%s", this.bucketName, this.isUseDefaultCredentials());
    }
}

