/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.sns.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.test.support.aws2.BaseAws2Resource;
import org.eclipse.microprofile.config.inject.ConfigProperty;

@Path(value="/aws2-sqs-sns")
@ApplicationScoped
public class Aws2SqsSnsResource
extends BaseAws2Resource {
    @ConfigProperty(name="aws-sqs.queue-name")
    String queueName;
    @ConfigProperty(name="aws-sqs.sns-receiver-queue-name")
    String snsReceiverQueueName;
    @ConfigProperty(name="aws2-sqs.sns-receiver-queue-arn")
    String snsReceiverQueueArn;
    @ConfigProperty(name="aws-sns.topic-name")
    String topicName;
    @ConfigProperty(name="aws-sqs.sns-fifo-receiver-queue-name")
    String snsFifoReceiverQueueName;
    @ConfigProperty(name="aws2-sqs.sns-fifo-receiver-queue-arn")
    String snsFifoReceiverQueueArn;
    @ConfigProperty(name="aws-sns-fifo.topic-name")
    String fifoTopicName;
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;

    public Aws2SqsSnsResource() {
        super("sns");
    }

    @Path(value="/sqs/purge/queue/{queueName}")
    @DELETE
    @Produces(value={"text/plain"})
    public Response purgeQueue(@PathParam(value="queueName") String queueName) throws Exception {
        this.producerTemplate.sendBodyAndHeader(this.componentUri(queueName) + "&operation=purgeQueue", null, "CamelAwsSqsPrefix", (Object)queueName);
        return Response.ok().build();
    }

    @Path(value="/sns/send")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response snsSend(String message, @QueryParam(value="queueUrl") String queueUrl, @DefaultValue(value="false") @QueryParam(value="fifo") boolean fifo) throws Exception {
        String endpointUri = String.format("aws2-sns://%s?useDefaultCredentialsProvider=%s&subscribeSNStoSQS=true&queueUrl=RAW(%s)%s", fifo ? this.fifoTopicName : this.topicName, this.isUseDefaultCredentials(), fifo ? this.snsFifoReceiverQueueArn : this.snsReceiverQueueArn, fifo ? "&messageGroupIdStrategy=useExchangeId" : "");
        String response = (String)this.producerTemplate.requestBody(endpointUri, (Object)message, String.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }

    @Path(value="/sqs/receive/{queueName}/{deleteMessage}")
    @GET
    @Produces(value={"text/plain"})
    public String sqsReceive(@PathParam(value="queueName") String queueName, @PathParam(value="deleteMessage") String deleteMessage) throws Exception {
        return (String)this.consumerTemplate.receiveBody(this.componentUri(queueName) + "&?deleteAfterRead=" + deleteMessage + "&deleteIfFiltered=" + deleteMessage + "&defaultVisibilityTimeout=0", 10000L, String.class);
    }

    @Path(value="/sns/receiveViaSqs")
    @GET
    @Produces(value={"application/json"})
    public String sqsReceiveViaSqs() throws Exception {
        return (String)this.consumerTemplate.receiveBody(this.componentUri(this.snsReceiverQueueName), 10000L, String.class);
    }

    @Path(value="/snsFifo/receiveViaSqs")
    @GET
    @Produces(value={"application/json"})
    public String fifoSqsReceiveViaSqs() throws Exception {
        return (String)this.consumerTemplate.receiveBody(this.componentUri(this.snsFifoReceiverQueueName), 10000L, String.class);
    }

    private String componentUri(String queueName) {
        return "aws2-sqs://" + queueName + "?useDefaultCredentialsProvider=" + this.isUseDefaultCredentials();
    }
}

