/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.kinesis.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.net.URI;
import java.util.Queue;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.aws2.kinesis.Kinesis2Component;
import org.apache.camel.component.aws2.kinesis.KinesisConnection;
import org.apache.camel.quarkus.test.support.aws2.BaseAws2Resource;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@Path(value="/aws2-kinesis")
@ApplicationScoped
public class Aws2KinesisResource
extends BaseAws2Resource {
    private static final Logger log = Logger.getLogger(Aws2KinesisResource.class);
    @ConfigProperty(name="aws-kinesis.stream-name")
    String streamName;
    @ConfigProperty(name="aws-kinesis.stream-name-for-default-credentials")
    String streamNameForDefaultCredentials;
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    CamelContext camelContext;
    @Inject
    @Named(value="aws2KinesisMessages")
    Queue<String> aws2KinesisMessages;

    public Aws2KinesisResource() {
        super("kinesis");
    }

    @Path(value="/send")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response send(String message) throws Exception {
        String response = (String)this.producerTemplate.requestBodyAndHeader(this.componentUri(), (Object)message, "CamelAwsKinesisPartitionKey", (Object)"foo-partition-key", String.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }

    @Path(value="/receive")
    @GET
    @Produces(value={"text/plain"})
    public String receive() throws IOException {
        return this.aws2KinesisMessages.poll();
    }

    private String componentUri() {
        return "aws2-kinesis://" + (this.isUseDefaultCredentials() ? this.streamNameForDefaultCredentials : this.streamName) + "?useDefaultCredentialsProvider=" + this.isUseDefaultCredentials();
    }

    protected void onDefaultCredentialsProviderChange() throws Exception {
        KinesisConnection kc = ((Kinesis2Component)this.camelContext.getRegistry().findSingleByType(Kinesis2Component.class)).getConnection();
        kc.close();
        kc.setKinesisAsyncClient(null);
        kc.setKinesisClient(null);
        super.onDefaultCredentialsProviderChange();
    }
}

