/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.ddb.it;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;

@Path(value="/aws2-ddbstream")
@ApplicationScoped
public class Aws2DdbStreamResource {
    @Inject
    CamelContext camelContext;
    @Inject
    @Named(value="aws2DdbStreamReceivedEvents")
    List<Map<String, String>> aws2DdbStreamReceivedEvents;

    @Path(value="/change")
    @GET
    @Produces(value={"application/json"})
    public List<Map<String, String>> change() {
        return this.aws2DdbStreamReceivedEvents;
    }

    @Path(value="/clear")
    @GET
    public void clear() {
        this.aws2DdbStreamReceivedEvents.clear();
    }

    @GET
    @Path(value="/route/{routeId}/{operation}")
    @Produces(value={"text/plain"})
    public String route(@PathParam(value="routeId") String routeId, @PathParam(value="operation") String operation) throws Exception {
        switch (operation) {
            case "stop": {
                this.camelContext.getRouteController().stopRoute(routeId);
                break;
            }
            case "start": {
                this.camelContext.getRouteController().startRoute(routeId);
                break;
            }
            case "status": {
                return this.camelContext.getRouteController().getRouteStatus(routeId).name();
            }
        }
        return null;
    }
}

