/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.lambda.it;

import java.util.Locale;
import org.apache.camel.quarkus.test.support.aws2.Aws2TestEnvContext;
import org.apache.camel.quarkus.test.support.aws2.Aws2TestEnvCustomizer;
import org.apache.commons.lang3.RandomStringUtils;
import org.testcontainers.containers.localstack.LocalStackContainer;
import software.amazon.awssdk.services.iam.IamClient;
import software.amazon.awssdk.services.iam.model.AttachRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.CreateRoleRequest;
import software.amazon.awssdk.services.iam.model.DeleteRoleRequest;
import software.amazon.awssdk.services.iam.model.DetachRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.GetRoleRequest;
import software.amazon.awssdk.services.iam.waiters.IamWaiter;
import software.amazon.awssdk.services.sqs.SqsClient;
import software.amazon.awssdk.services.sqs.model.CreateQueueRequest;
import software.amazon.awssdk.services.sqs.model.DeleteQueueRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesRequest;
import software.amazon.awssdk.services.sqs.model.GetQueueAttributesResponse;
import software.amazon.awssdk.services.sqs.model.QueueAttributeName;

public class Aws2LambdaTestEnvCustomizer
implements Aws2TestEnvCustomizer {
    public LocalStackContainer.Service[] localstackServices() {
        return new LocalStackContainer.Service[]{LocalStackContainer.Service.LAMBDA, LocalStackContainer.Service.IAM, LocalStackContainer.Service.SQS};
    }

    public LocalStackContainer.Service[] exportCredentialsForLocalstackServices() {
        return new LocalStackContainer.Service[]{LocalStackContainer.Service.LAMBDA};
    }

    public void customize(Aws2TestEnvContext envContext) {
        String id = RandomStringUtils.randomAlphanumeric((int)16).toLowerCase(Locale.ROOT);
        String roleName = "cq-lambda-" + id;
        IamClient iamClient = (IamClient)envContext.client(LocalStackContainer.Service.IAM, IamClient::builder);
        String roleArn = iamClient.createRole((CreateRoleRequest)CreateRoleRequest.builder().roleName(roleName).path("/service-role/").assumeRolePolicyDocument("{\n  \"Version\": \"2012-10-17\",\n  \"Statement\": [\n    {\n      \"Effect\": \"Allow\",\n      \"Principal\": {\n        \"Service\": \"lambda.amazonaws.com\"\n      },\n      \"Action\": \"sts:AssumeRole\"\n    }\n  ]\n}").build()).role().arn();
        envContext.closeable(() -> iamClient.deleteRole((DeleteRoleRequest)DeleteRoleRequest.builder().roleName(roleName).build()));
        String policyArn = "arn:aws:iam::aws:policy/service-role/AWSLambdaSQSQueueExecutionRole";
        AttachRolePolicyRequest attachRolePolicyRequest = (AttachRolePolicyRequest)AttachRolePolicyRequest.builder().roleName(roleName).policyArn("arn:aws:iam::aws:policy/service-role/AWSLambdaSQSQueueExecutionRole").build();
        iamClient.attachRolePolicy(attachRolePolicyRequest);
        envContext.closeable(() -> iamClient.detachRolePolicy((DetachRolePolicyRequest)DetachRolePolicyRequest.builder().roleName(roleName).policyArn("arn:aws:iam::aws:policy/service-role/AWSLambdaSQSQueueExecutionRole").build()));
        try (IamWaiter w = iamClient.waiter();){
            w.waitUntilRoleExists((GetRoleRequest)GetRoleRequest.builder().roleName(roleName).build());
        }
        envContext.property("aws-lambda.role-arn", roleArn);
        String queueName = "camel-quarkus-" + RandomStringUtils.randomAlphanumeric((int)49).toLowerCase(Locale.ROOT);
        SqsClient sqsClient = (SqsClient)envContext.client(LocalStackContainer.Service.SQS, SqsClient::builder);
        CreateQueueRequest createQueueRequest = (CreateQueueRequest)CreateQueueRequest.builder().queueName(queueName).build();
        String queueUrl = sqsClient.createQueue(createQueueRequest).queueUrl();
        envContext.closeable(() -> sqsClient.deleteQueue((DeleteQueueRequest)DeleteQueueRequest.builder().queueUrl(queueUrl).build()));
        GetQueueAttributesRequest getQueueAttributesRequest = (GetQueueAttributesRequest)GetQueueAttributesRequest.builder().attributeNames(new QueueAttributeName[]{QueueAttributeName.QUEUE_ARN}).queueUrl(queueUrl).build();
        GetQueueAttributesResponse getQueueAttributesResponse = sqsClient.getQueueAttributes(getQueueAttributesRequest);
        String queueArn = (String)getQueueAttributesResponse.attributes().get(QueueAttributeName.QUEUE_ARN);
        envContext.property("aws-lambda.event-source-arn", queueArn);
    }
}

