/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.lambda.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.ExtractableResponse;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.camel.quarkus.test.support.aws2.Aws2TestResource;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=Aws2TestResource.class)
class Aws2LambdaTest {
    private static final Logger LOG = Logger.getLogger(Aws2LambdaTest.class);
    private static final String INITIAL_FUNCTION_SOURCE = "def handler(event, context):\n    message = 'Hello {}'.format(event['firstName'])\n    return {\n        'greetings' : message\n    }\n";
    private static final String UPDATED_FUNCTION_SOURCE = "def handler(event, context):\n    message = 'Hello updated {}'.format(event['firstName'])\n    return {\n        'greetings' : message\n    }\n";

    Aws2LambdaTest() {
    }

    @Test
    public void performingOperationsOnLambdaFunctionShouldSucceed() {
        String functionName = "cqFunction" + UUID.randomUUID().toString().replace("-", "");
        Awaitility.await().pollDelay(6L, TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
            ExtractableResponse response = ((ValidatableResponse)((Response)RestAssured.given().contentType("application/zip").body(Aws2LambdaTest.createInitialLambdaFunctionZip()).post("/aws2-lambda/function/create/" + functionName, new Object[0])).then()).extract();
            switch (response.statusCode()) {
                case 201: {
                    LOG.infof("Lambda function %s created", (Object)functionName);
                    return true;
                }
                case 400: {
                    LOG.infof("Could not create Lambda function %s yet (will retry): %d %s", (Object)functionName, (Object)response.statusCode(), (Object)response.body().asString());
                    return false;
                }
            }
            throw new RuntimeException("Unexpected status from /aws2-lambda/function/create " + response.statusCode() + " " + response.body().asString());
        });
        String functionArn = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).get("/aws2-lambda/function/getArn/" + functionName, new Object[0])).then()).statusCode(200)).extract().asString();
        Assertions.assertNotNull((Object)functionArn);
        this.getUpdateListAndInvokeFunctionShouldSucceed(functionName);
        this.createGetDeleteAndListAliasShouldSucceed(functionName);
        this.createListDeleteFunctionTagsShouldSucceed(functionName, functionArn);
        this.publishAndListVersionShouldSucceed(functionName);
        this.createListAndDeleteEventSourceMappingShouldSucceed(functionName);
        ((ValidatableResponse)((Response)RestAssured.given().delete("/aws2-lambda/function/delete/" + functionName, new Object[0])).then()).statusCode(204);
    }

    public void getUpdateListAndInvokeFunctionShouldSucceed(String functionName) {
        String name = "Joe " + UUID.randomUUID().toString().replace("-", "");
        Awaitility.await().pollDelay(1L, TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
            String state = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/aws2-lambda/function/getState/" + functionName, new Object[0])).then()).statusCode(200)).extract().asString();
            if (!"Active".equals(state)) {
                String format = "The function with name '%s' has state '%s', so retrying";
                LOG.infof(format, (Object)functionName, (Object)state);
                return false;
            }
            String format = "The function with name '%s' has state 'Active', so moving to next step";
            LOG.infof(format, (Object)functionName);
            return true;
        });
        ((ValidatableResponse)((Response)RestAssured.given().contentType("application/zip").body(Aws2LambdaTest.createUpdatedLambdaFunctionZip()).put("/aws2-lambda/function/update/" + functionName, new Object[0])).then()).statusCode(200);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().accept(ContentType.JSON).get("/aws2-lambda/function/list", new Object[0])).then()).statusCode(200)).body("$", Matchers.hasItem((Object)functionName), new Object[0]);
        Awaitility.await().pollDelay(200L, TimeUnit.MILLISECONDS).pollInterval(500L, TimeUnit.MILLISECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
            ExtractableResponse response = ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body("{ \"firstName\": \"" + name + "\"}").post("/aws2-lambda/function/invoke/" + functionName, new Object[0])).then()).extract();
            String format = "Execution of aws2-lambda/invoke/%s returned status %d and content %s";
            LOG.infof(format, (Object)functionName, (Object)response.statusCode(), (Object)response.asString());
            switch (response.statusCode()) {
                case 200: {
                    String greetings = response.jsonPath().getString("greetings");
                    return greetings;
                }
            }
            return null;
        }, Matchers.is((Object)("Hello updated " + name)));
    }

    public void createGetDeleteAndListAliasShouldSucceed(String functionName) {
        String functionVersion = "$LATEST";
        String aliasName = "alias_LATEST_" + functionName;
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("functionName", new Object[]{functionName}).queryParam("functionVersion", new Object[]{functionVersion}).queryParam("aliasName", new Object[]{aliasName}).post("/aws2-lambda/alias/create/", new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("functionName", new Object[]{functionName}).queryParam("aliasName", new Object[]{aliasName}).get("/aws2-lambda/alias/get/", new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"$LATEST"), new Matcher[0]);
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("functionName", new Object[]{functionName}).queryParam("aliasName", new Object[]{aliasName}).delete("/aws2-lambda/alias/delete", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("functionName", new Object[]{functionName}).accept(ContentType.JSON).get("/aws2-lambda/alias/list", new Object[0])).then()).statusCode(200)).body("$", Matchers.not((Matcher)Matchers.hasItem((Object)aliasName)), new Object[0]);
    }

    public void createListDeleteFunctionTagsShouldSucceed(String functionName, String functionArn) {
        String uuid = UUID.randomUUID().toString().replace("-", "");
        String tagResourceKey = functionName + "-tagKey-" + uuid;
        String tagResourceValue = functionName + "-tagValue-" + uuid;
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("functionArn", new Object[]{functionArn}).queryParam("tagResourceKey", new Object[]{tagResourceKey}).queryParam("tagResourceValue", new Object[]{tagResourceValue}).post("/aws2-lambda/tag/create", new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("functionArn", new Object[]{functionArn}).get("/aws2-lambda/tag/list", new Object[0])).then()).statusCode(200)).body(tagResourceKey, Matchers.is((Object)tagResourceValue), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("functionArn", new Object[]{functionArn}).queryParam("tagResourceKey", new Object[]{tagResourceKey}).delete("/aws2-lambda/tag/delete", new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("functionArn", new Object[]{functionArn}).get("/aws2-lambda/tag/list", new Object[0])).then()).statusCode(200)).body(tagResourceKey, Matchers.is((Matcher)Matchers.emptyOrNullString()), new Object[0]);
    }

    public void publishAndListVersionShouldSucceed(String functionName) {
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("functionName", new Object[]{functionName}).get("/aws2-lambda/version/list", new Object[0])).then()).statusCode(200)).body("$", Matchers.not((Matcher)Matchers.hasItem((Object)"1")), new Object[0]);
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("functionName", new Object[]{functionName}).post("/aws2-lambda/version/publish", new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("functionName", new Object[]{functionName}).get("/aws2-lambda/version/list", new Object[0])).then()).statusCode(200)).body("$", Matchers.hasItem((Object)"1"), new Object[0]);
    }

    public void createListAndDeleteEventSourceMappingShouldSucceed(String functionName) {
        String eventSourceMappingUuid = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("functionName", new Object[]{functionName}).post("/aws2-lambda/event-source-mapping/create", new Object[0])).then()).statusCode(201)).extract().asString();
        Assertions.assertNotNull((Object)eventSourceMappingUuid);
        Awaitility.await().pollDelay(10L, TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
            Map eventSourceMappingStatuses = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("functionName", new Object[]{functionName}).get("/aws2-lambda/event-source-mapping/list", new Object[0])).then()).statusCode(200)).extract().jsonPath().getMap("$", String.class, String.class);
            if (!eventSourceMappingStatuses.containsKey(eventSourceMappingUuid)) {
                LOG.infof("Found no event source mapping with id '%s', so retrying", (Object)eventSourceMappingUuid);
                return false;
            }
            String status = (String)eventSourceMappingStatuses.get(eventSourceMappingUuid);
            if (!"Enabled".equals(status)) {
                String format = "The event source mapping with id '%s' has status '%s', so retrying";
                LOG.infof(format, (Object)eventSourceMappingUuid, (Object)status);
                return false;
            }
            String format = "The event source mapping with id '%s' has status 'Enabled', so moving to next step";
            LOG.infof(format, (Object)eventSourceMappingUuid);
            return true;
        });
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("eventSourceMappingUuid", new Object[]{eventSourceMappingUuid}).delete("/aws2-lambda/event-source-mapping/delete", new Object[0])).then()).statusCode(204);
        Awaitility.await().pollDelay(16L, TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
            Map eventSourceMappingStatuses = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().queryParam("functionName", new Object[]{functionName}).get("/aws2-lambda/event-source-mapping/list", new Object[0])).then()).statusCode(200)).extract().jsonPath().getMap("$", String.class, String.class);
            if (eventSourceMappingStatuses.containsKey(eventSourceMappingUuid)) {
                String format = "The event source mapping with id '%s' is still present with status '%s', so retrying";
                LOG.infof(format, (Object)eventSourceMappingUuid, eventSourceMappingStatuses.get(eventSourceMappingUuid));
                return false;
            }
            return true;
        });
    }

    static byte[] createInitialLambdaFunctionZip() {
        return Aws2LambdaTest.createLambdaFunctionZip(INITIAL_FUNCTION_SOURCE);
    }

    static byte[] createUpdatedLambdaFunctionZip() {
        return Aws2LambdaTest.createLambdaFunctionZip(UPDATED_FUNCTION_SOURCE);
    }

    static byte[] createLambdaFunctionZip(String source) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ZipOutputStream out = new ZipOutputStream(baos);){
            out.putNextEntry(new ZipEntry("index.py"));
            out.write(source.getBytes(StandardCharsets.UTF_8));
            out.closeEntry();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create a zip file", e);
        }
        return baos.toByteArray();
    }
}

