/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.kinesis.it;

import java.net.URI;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import software.amazon.awssdk.services.kinesis.model.Record;

@Path(value="/aws2-kinesis")
@ApplicationScoped
public class Aws2KinesisResource {
    @ConfigProperty(name="aws-kinesis.stream-name")
    String streamName;
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;

    @Path(value="/send")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response send(String message) throws Exception {
        String response = (String)this.producerTemplate.requestBodyAndHeader(this.componentUri(), (Object)message, "CamelAwsKinesisPartitionKey", (Object)"foo-partition-key", String.class);
        return Response.created((URI)new URI("https://camel.apache.org/")).entity((Object)response).build();
    }

    @Path(value="/receive")
    @GET
    @Produces(value={"application/json"})
    public String receive() {
        Record record = (Record)this.consumerTemplate.receiveBody(this.componentUri(), 10000L, Record.class);
        if (record == null) {
            return null;
        }
        return record.data().asUtf8String();
    }

    private String componentUri() {
        return "aws2-kinesis://" + this.streamName;
    }
}

