/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.ddb.it;

import io.quarkus.runtime.StartupEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.apache.camel.ConsumerTemplate;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.Record;
import software.amazon.awssdk.services.dynamodb.model.StreamRecord;

@Path(value="/aws2-ddbstream")
@ApplicationScoped
public class Aws2DdbStreamResource {
    @ConfigProperty(name="aws-ddb.table-name")
    String tableName;
    @Inject
    ConsumerTemplate consumerTemplate;

    void startup(@Observes StartupEvent event) {
        this.consumerTemplate.receiveBody(this.componentUri(), 1000L);
    }

    @Path(value="/change")
    @GET
    @Produces(value={"application/json"})
    public Map<String, String> change() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Record record = (Record)this.consumerTemplate.receiveBody(this.componentUri(), 10000L, Record.class);
        if (record == null) {
            return null;
        }
        StreamRecord item = record.dynamodb();
        result.put("key", ((AttributeValue)item.keys().get("key")).s());
        if (item.hasOldImage()) {
            result.put("old", ((AttributeValue)item.oldImage().get("value")).s());
        }
        if (item.hasNewImage()) {
            result.put("new", ((AttributeValue)item.newImage().get("value")).s());
        }
        return result;
    }

    private String componentUri() {
        return "aws2-ddbstream://" + this.tableName;
    }
}

