/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.ddb.it;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.aws2.ddb.Ddb2Operations;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import software.amazon.awssdk.services.dynamodb.model.AttributeAction;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;

@Path(value="/aws2-ddb")
@ApplicationScoped
public class Aws2DdbResource {
    @ConfigProperty(name="aws-ddb.table-name")
    String tableName;
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/item/{key}")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response post(final String message, final @PathParam(value="key") String key) throws Exception {
        final HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>(){
            {
                this.put("key", (AttributeValue)AttributeValue.builder().s(key).build());
                this.put("value", (AttributeValue)AttributeValue.builder().s(message).build());
            }
        };
        this.producerTemplate.sendBodyAndHeaders(this.componentUri(Ddb2Operations.PutItem), (Object)message, (Map)new HashMap<String, Object>(){
            {
                this.put("CamelAwsDdbConsistentRead", true);
                this.put("CamelAwsDdbItem", item);
            }
        });
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @Path(value="/item/{key}")
    @GET
    @Produces(value={"text/plain"})
    public String getItem(@PathParam(value="key") String key) throws Exception {
        Map item = (Map)this.producerTemplate.send(this.componentUri(Ddb2Operations.GetItem), e -> {
            e.getMessage().setHeader("CamelAwsDdbConsistentRead", (Object)true);
            e.getMessage().setHeader("CamelAwsDdbAttributeNames", new HashSet<String>(Arrays.asList("key", "value")));
            e.getMessage().setHeader("CamelAwsDdbKey", Collections.singletonMap("key", (AttributeValue)AttributeValue.builder().s(key).build()));
        }).getMessage().getHeader("CamelAwsDdbAttributes", Map.class);
        AttributeValue val = (AttributeValue)item.get("value");
        return val == null ? null : val.s();
    }

    @Path(value="/item/{key}")
    @PUT
    @Produces(value={"text/plain"})
    public void updateItem(final String message, final @PathParam(value="key") String key) throws Exception {
        this.producerTemplate.sendBodyAndHeaders(this.componentUri(Ddb2Operations.UpdateItem), null, (Map)new HashMap<String, Object>(){
            {
                this.put("CamelAwsDdbKey", Collections.singletonMap("key", (AttributeValue)AttributeValue.builder().s(key).build()));
                this.put("CamelAwsDdbUpdateValues", Collections.singletonMap("value", (AttributeValueUpdate)AttributeValueUpdate.builder().action(AttributeAction.PUT).value((AttributeValue)AttributeValue.builder().s(message).build()).build()));
            }
        });
    }

    @Path(value="/item/{key}")
    @DELETE
    @Produces(value={"text/plain"})
    public void deleteItem(final @PathParam(value="key") String key) throws Exception {
        this.producerTemplate.sendBodyAndHeaders(this.componentUri(Ddb2Operations.DeleteItem), null, (Map)new HashMap<String, Object>(){
            {
                this.put("CamelAwsDdbConsistentRead", true);
                this.put("CamelAwsDdbKey", Collections.singletonMap("key", (AttributeValue)AttributeValue.builder().s(key).build()));
            }
        });
    }

    private String componentUri(Ddb2Operations op) {
        return "aws2-ddb://" + this.tableName + "?operation=" + op;
    }
}

