/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2;

import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.aws2.s3.AWS2S3Operations;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import software.amazon.awssdk.services.s3.model.S3Object;

@Path(value="/aws2")
@ApplicationScoped
public class Aws2S3Resource {
    @Inject
    ProducerTemplate producerTemplate;
    @Inject
    ConsumerTemplate consumerTemplate;
    @ConfigProperty(name="aws-s3.bucket-name")
    String bucketName;

    @Path(value="s3/object/{key}")
    @POST
    @Consumes(value={"text/plain"})
    public Response post(String message, @PathParam(value="key") String key) throws Exception {
        this.producerTemplate.sendBodyAndHeader(this.componentUri(), (Object)message, "CamelAwsS3Key", (Object)key);
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @Path(value="s3/object/{key}")
    @GET
    @Produces(value={"text/plain"})
    public String get(@PathParam(value="key") String key) throws Exception {
        return (String)this.producerTemplate.requestBodyAndHeader(this.componentUri(AWS2S3Operations.getObject), null, "CamelAwsS3Key", (Object)key, String.class);
    }

    @Path(value="s3/poll-object/{key}")
    @GET
    @Produces(value={"text/plain"})
    public String pollObject(@PathParam(value="key") String key) throws Exception {
        return (String)this.consumerTemplate.receiveBody(this.componentUri() + "?fileName=" + key, 10000L, String.class);
    }

    @Path(value="s3/object/{key}")
    @DELETE
    @Produces(value={"text/plain"})
    public Response read(@PathParam(value="key") String key) throws Exception {
        this.producerTemplate.sendBodyAndHeader(this.componentUri(AWS2S3Operations.deleteObject), null, "CamelAwsS3Key", (Object)key);
        return Response.noContent().build();
    }

    @Path(value="s3/object-keys")
    @GET
    @Produces(value={"application/json"})
    public List<String> objectKey() throws Exception {
        List objects = (List)this.producerTemplate.requestBody(this.componentUri(AWS2S3Operations.listObjects), null, List.class);
        return objects.stream().map(S3Object::key).collect(Collectors.toList());
    }

    private String componentUri(AWS2S3Operations operation) {
        return String.format("aws2-s3://%s?operation=%s", this.bucketName, operation);
    }

    private String componentUri() {
        return String.format("aws2-s3://%s", this.bucketName);
    }
}

