/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.ddb.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.ExtractableResponse;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.component.aws2.ddb.Ddb2Operations;
import org.apache.camel.quarkus.component.aws2.ddb.it.Aws2DdbResource;
import org.apache.camel.quarkus.test.support.aws2.Aws2TestResource;
import org.apache.camel.quarkus.test.support.aws2.BaseAWs2TestSupport;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Test;
import software.amazon.awssdk.services.dynamodb.model.TableStatus;

@QuarkusTest
@QuarkusTestResource(value=Aws2TestResource.class)
class Aws2DdbTest
extends BaseAWs2TestSupport {
    private static final Logger LOG = Logger.getLogger(Aws2DdbTest.class);

    public Aws2DdbTest() {
        super("/aws2-ddb");
    }

    @Test
    public void crud() {
        String key = "key" + UUID.randomUUID().toString().replace("-", "");
        String msg = "val" + UUID.randomUUID().toString().replace("-", "");
        ((ValidatableResponse)RestAssured.get((String)("/aws2-ddb/item/" + key), (Object[])new Object[0]).then()).statusCode(204);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).queryParam("table", new Object[]{Aws2DdbResource.Table.basic}).post("/aws2-ddb/item/" + key, new Object[0])).then()).statusCode(201);
        Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
            ExtractableResponse result = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/aws2-ddb/item/" + key), (Object[])new Object[0]).then()).statusCode((Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)200), (Matcher)Matchers.is((Object)204)))).extract();
            LOG.info((Object)("Expecting " + msg + " got " + result.statusCode() + ": " + result.body().asString()));
            return result.body().asString();
        }, Matchers.is((Object)msg));
        String newMsg = "newVal" + UUID.randomUUID().toString().replace("-", "");
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("table", new Object[]{Aws2DdbResource.Table.basic}).body(newMsg).put("/aws2-ddb/item/" + key, new Object[0])).then()).statusCode(204);
        Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
            ExtractableResponse result = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/aws2-ddb/item/" + key), (Object[])new Object[0]).then()).statusCode((Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)200), (Matcher)Matchers.is((Object)204)))).extract();
            LOG.info((Object)("Expecting " + newMsg + " got " + result.statusCode() + ": " + result.body().asString()));
            return result.body().asString();
        }, Matchers.is((Object)newMsg));
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("table", new Object[]{Aws2DdbResource.Table.basic}).delete("/aws2-ddb/item/" + key, new Object[0])).then()).statusCode(204);
        Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
            ExtractableResponse result = ((ValidatableResponse)RestAssured.get((String)("/aws2-ddb/item/" + key), (Object[])new Object[0]).then()).extract();
            LOG.info((Object)("Expecting " + msg + " got " + result.statusCode() + ": " + result.body().asString()));
            return result.statusCode();
        }, Matchers.is((Object)204));
    }

    @Test
    public void operations() {
        String key1 = "key-1-" + UUID.randomUUID().toString().replace("-", "");
        String msg1 = "val-1-" + UUID.randomUUID().toString().replace("-", "");
        String key2 = "key-2-" + UUID.randomUUID().toString().replace("-", "");
        String msg2 = "val-2-" + UUID.randomUUID().toString().replace("-", "");
        String key3 = "key-3-" + UUID.randomUUID().toString().replace("-", "");
        String msg3 = "val-3-" + UUID.randomUUID().toString().replace("-", "");
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).queryParam("table", new Object[]{Aws2DdbResource.Table.operations}).body(msg1).post("/aws2-ddb/item/" + key1, new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg2).queryParam("table", new Object[]{Aws2DdbResource.Table.operations}).post("/aws2-ddb/item/" + key2, new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg3).queryParam("table", new Object[]{Aws2DdbResource.Table.operations}).post("/aws2-ddb/item/" + key3, new Object[0])).then()).statusCode(201);
        Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
            ExtractableResponse result = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(Stream.of(key1, key2).collect(Collectors.toList())).post("/aws2-ddb/batchItems", new Object[0])).then()).statusCode(200)).extract();
            LOG.info((Object)("Expecting 2 items, got " + result.statusCode() + ": " + result.body().asString()));
            return result.jsonPath().getMap("$");
        }, map -> map.size() == 2 && msg1.equals(map.get(key1)) && msg2.equals(map.get(key2)));
        Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
            ExtractableResponse result = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(key3).post("/aws2-ddb/query", new Object[0])).then()).statusCode(200)).extract();
            LOG.info((Object)("Expecting 1 item, got " + result.statusCode() + ": " + result.body().asString()));
            return result.jsonPath().getMap("$");
        }, map -> map.size() == 1 && msg3.equals(map.get(key3)));
        Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
            ExtractableResponse result = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/aws2-ddb/scan", (Object[])new Object[0]).then()).statusCode(200)).extract();
            LOG.info((Object)("Expecting 3 items, got " + result.statusCode() + ": " + result.body().asString()));
            return result.jsonPath().getMap("$");
        }, map -> map.size() == 3 && msg1.equals(map.get(key1)) && msg2.equals(map.get(key2)) && msg3.equals(map.get(key3)));
        Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
            ExtractableResponse result = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)Ddb2Operations.DescribeTable).post("/aws2-ddb/operation", new Object[0])).then()).statusCode(200)).extract();
            LOG.info((Object)("Expecting table description, got " + result.statusCode() + ": " + result.body().asString()));
            return result.jsonPath().getMap("$");
        }, map -> map.size() == 8 && map.containsKey("CamelAwsDdbCreationDate") && map.containsKey("CamelAwsDdbReadCapacity") && TableStatus.ACTIVE.name().equals(map.get("CamelAwsDdbTableStatus")) && map.containsKey("CamelAwsDdbWriteCapacity") && map.containsKey("CamelAwsDdbTableSize") && map.containsKey("CamelAwsDdbKeySchema") && map.containsKey("CamelAwsDdbTableItemCount") && Aws2DdbResource.Table.operations == Aws2DdbResource.Table.valueOf((String)((String)map.get("CamelAwsDdbTableName"))));
        Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
            ExtractableResponse result = ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)5).post("/aws2-ddb/updateTable", new Object[0])).then()).extract();
            LOG.info((Object)("Expecting table update, got " + result.statusCode() + ": " + result.body().asString()));
            return result.statusCode();
        }, Matchers.is((Object)201));
        Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
            ExtractableResponse result = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)Ddb2Operations.DeleteTable).post("/aws2-ddb/operation", new Object[0])).then()).statusCode(200)).extract();
            LOG.info((Object)("Expecting table deletion, got " + result.statusCode() + ": " + result.body().asString()));
            return result.jsonPath().getMap("$");
        }, map -> map.size() == 7 && map.containsKey("CamelAwsDdbCreationDate") && map.containsKey("CamelAwsDdbTableStatus") && map.containsKey("CamelAwsDdbTableSize") && map.containsKey("CamelAwsDdbKeySchema") && map.containsKey("CamelAwsDdbTableItemCount") && Aws2DdbResource.Table.operations == Aws2DdbResource.Table.valueOf((String)((String)map.get("CamelAwsDdbTableName"))) && ((Map)map.get("CamelAwsDdbProvisionedThroughput")).size() == 2 && ((Map)map.get("CamelAwsDdbProvisionedThroughput")).get("CamelAwsDdbReadCapacity").equals(5) && ((Map)map.get("CamelAwsDdbProvisionedThroughput")).get("CamelAwsDdbWriteCapacity").equals(5));
        Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
            ExtractableResponse result = ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)Ddb2Operations.DescribeTable).post("/aws2-ddb/operation", new Object[0])).then()).statusCode(200)).extract();
            LOG.info((Object)("Expecting table description of non-existing table, got " + result.statusCode() + ": " + result.body().asString()));
            return result.jsonPath().getMap("$");
        }, map -> map.isEmpty());
    }

    public void testMethodForDefaultCredentialsProvider() {
        String key = "key" + UUID.randomUUID().toString().replace("-", "");
        ((ValidatableResponse)RestAssured.get((String)("/aws2-ddb/item/" + key), (Object[])new Object[0]).then()).statusCode(204);
    }
}

