/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.ddb.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.ExtractableResponse;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.camel.ServiceStatus;
import org.apache.camel.quarkus.component.aws2.ddb.it.Aws2DdbResource;
import org.apache.camel.quarkus.test.support.aws2.Aws2TestResource;
import org.awaitility.Awaitility;
import org.hamcrest.Matchers;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Test;

@QuarkusTest
@QuarkusTestResource(value=Aws2TestResource.class)
class Aws2DdbStreamTest {
    private static final Logger LOG = Logger.getLogger(Aws2DdbStreamTest.class);

    Aws2DdbStreamTest() {
    }

    @Test
    public void stream() {
        String key1 = "key-1-" + UUID.randomUUID().toString().replace("-", "");
        String msg1 = "val-1" + UUID.randomUUID().toString().replace("-", "");
        String key2 = "key-2-" + UUID.randomUUID().toString().replace("-", "");
        String msg2 = "val-2-" + UUID.randomUUID().toString().replace("-", "");
        String key3 = "key-3-" + UUID.randomUUID().toString().replace("-", "");
        String msg3 = "val-3-" + UUID.randomUUID().toString().replace("-", "");
        this.routeController("start", null);
        this.routeController("status", ServiceStatus.Started.name());
        this.waitForStreamConsumerToStart();
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg1).queryParam("table", new Object[]{Aws2DdbResource.Table.stream}).post("/aws2-ddb/item/" + key1, new Object[0])).then()).statusCode(201);
        String newMsg = "newVal" + UUID.randomUUID().toString().replace("-", "");
        ((ValidatableResponse)((Response)RestAssured.given().body(newMsg).queryParam("table", new Object[]{Aws2DdbResource.Table.stream}).put("/aws2-ddb/item/" + key1, new Object[0])).then()).statusCode(204);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg2).queryParam("table", new Object[]{Aws2DdbResource.Table.stream}).post("/aws2-ddb/item/" + key2, new Object[0])).then()).statusCode(201);
        StringBuilder put2SeqNumber = new StringBuilder();
        Awaitility.await().atMost(120L, TimeUnit.SECONDS).until(() -> {
            ExtractableResponse result = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/aws2-ddbstream/change", (Object[])new Object[0]).then()).statusCode(200)).extract();
            List retVal = result.jsonPath().getList("$", Map.class);
            LOG.info((Object)("Expecting 3 (+ 1 init) events got " + result.statusCode() + ": " + result.body().asString()));
            retVal = retVal.stream().filter(m -> !String.valueOf(m.get("key")).startsWith("initKey")).collect(Collectors.toList());
            if (retVal.size() == 3 && retVal.get(2) != null && ((Map)retVal.get(2)).get("sequenceNumber") != null) {
                put2SeqNumber.append((String)((Map)retVal.get(2)).get("sequenceNumber"));
            }
            return retVal;
        }, list -> list.size() == 3 && key1.equals(((Map)list.get(0)).get("key")) && msg1.equals(((Map)list.get(0)).get("new")) && key1.equals(((Map)list.get(1)).get("key")) && msg1.equals(((Map)list.get(1)).get("old")) && newMsg.equals(((Map)list.get(1)).get("new")) && key2.equals(((Map)list.get(2)).get("key")) && msg2.equals(((Map)list.get(2)).get("new")) && put2SeqNumber.length() > 0);
        ((ValidatableResponse)((Response)RestAssured.given().get("/aws2-ddbstream/clear", new Object[0])).then()).statusCode(204);
        this.routeController("stop", null);
        this.routeController("status", ServiceStatus.Stopped.name());
        this.routeController("start", null);
        this.routeController("status", ServiceStatus.Started.name());
        this.waitForStreamConsumerToStart();
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg3).queryParam("table", new Object[]{Aws2DdbResource.Table.stream}).post("/aws2-ddb/item/" + key3, new Object[0])).then()).statusCode(201);
        ((ValidatableResponse)((Response)RestAssured.given().queryParam("table", new Object[]{Aws2DdbResource.Table.stream}).delete("/aws2-ddb/item/" + key3, new Object[0])).then()).statusCode(204);
        Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
            ExtractableResponse result = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/aws2-ddbstream/change", (Object[])new Object[0]).then()).statusCode(200)).extract();
            List retVal = result.jsonPath().getList("$", Map.class);
            retVal = retVal.stream().filter(m -> !String.valueOf(m.get("key")).startsWith("initKey")).collect(Collectors.toList());
            LOG.info((Object)("Expecting 2 events, got " + result.statusCode() + ": " + retVal));
            return retVal;
        }, list -> list.size() == 2 && key3.equals(((Map)list.get(0)).get("key")) && msg3.equals(((Map)list.get(0)).get("new")) && key3.equals(((Map)list.get(1)).get("key")) && msg3.equals(((Map)list.get(1)).get("old")));
    }

    private void waitForStreamConsumerToStart() {
        String initKeyPrefix = "initKey";
        String initMsg = "val";
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("val").queryParam("table", new Object[]{Aws2DdbResource.Table.stream}).post("/aws2-ddb/item/initKey" + UUID.randomUUID().toString().replace("-", ""), new Object[0])).then()).statusCode(201);
        Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
            ExtractableResponse result = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/aws2-ddbstream/change", (Object[])new Object[0]).then()).statusCode(200)).extract();
            LOG.info((Object)("Expecting at least 1 init event, got " + result.statusCode() + ": " + result.body().asString()));
            List res = result.jsonPath().getList("$", Map.class);
            if (res.isEmpty()) {
                ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body("val").queryParam("table", new Object[]{Aws2DdbResource.Table.stream}).post("/aws2-ddb/item/initKey" + UUID.randomUUID().toString().replace("-", ""), new Object[0])).then()).statusCode(201);
            }
            return res;
        }, list -> !list.isEmpty());
    }

    private String routeController(String operation, String expectedResult) {
        String routeId = "aws2DdbStreamRoute";
        if (expectedResult == null) {
            ((ValidatableResponse)((Response)RestAssured.given().get("/aws2-ddbstream/route/" + routeId + "/" + operation, new Object[0])).then()).statusCode(204);
        } else {
            Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/aws2-ddbstream/route/" + routeId + "/" + operation), (Object[])new Object[0]).then()).statusCode(200)).extract().asString(), Matchers.is((Object)expectedResult));
        }
        return null;
    }
}

