/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.ddb.it;

import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.camel.CamelContext;

@Path(value="/aws2-ddbstream")
@ApplicationScoped
public class Aws2DdbStreamResource {
    @Inject
    CamelContext camelContext;
    @Inject
    @Named(value="aws2DdbStreamReceivedEvents")
    List<Map<String, String>> aws2DdbStreamReceivedEvents;

    @Path(value="/change")
    @GET
    @Produces(value={"application/json"})
    public List<Map<String, String>> change() {
        return this.aws2DdbStreamReceivedEvents;
    }

    @Path(value="/clear")
    @GET
    public void clear() {
        this.aws2DdbStreamReceivedEvents.clear();
    }

    @GET
    @Path(value="/route/{routeId}/{operation}")
    @Produces(value={"text/plain"})
    public String route(@PathParam(value="routeId") String routeId, @PathParam(value="operation") String operation) throws Exception {
        switch (operation) {
            case "stop": {
                this.camelContext.getRouteController().stopRoute(routeId);
                break;
            }
            case "start": {
                this.camelContext.getRouteController().startRoute(routeId);
                break;
            }
            case "status": {
                return this.camelContext.getRouteController().getRouteStatus(routeId).name();
            }
        }
        return null;
    }
}

