/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.ddb.it;

import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.camel.Message;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.component.aws2.ddb.Ddb2Operations;
import org.apache.camel.util.CollectionHelper;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import software.amazon.awssdk.services.dynamodb.model.AttributeAction;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.AttributeValueUpdate;
import software.amazon.awssdk.services.dynamodb.model.ComparisonOperator;
import software.amazon.awssdk.services.dynamodb.model.Condition;
import software.amazon.awssdk.services.dynamodb.model.KeysAndAttributes;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputDescription;

@Path(value="/aws2-ddb")
@ApplicationScoped
public class Aws2DdbResource {
    @ConfigProperty(name="aws-ddb.table-name")
    String tableName;
    @ConfigProperty(name="aws-ddb.operations-table-name")
    String operationsTableName;
    @ConfigProperty(name="aws-ddb.stream-table-name")
    String streamTableName;
    @Inject
    ProducerTemplate producerTemplate;

    @Path(value="/item/{key}")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response post(final String message, final @PathParam(value="key") String key, @QueryParam(value="table") String table) throws Exception {
        final HashMap<String, AttributeValue> item = new HashMap<String, AttributeValue>(){
            {
                this.put("key", (AttributeValue)AttributeValue.builder().s(key).build());
                this.put("value", (AttributeValue)AttributeValue.builder().s(message).build());
            }
        };
        this.producerTemplate.sendBodyAndHeaders(this.componentUri(Table.valueOf(table), Ddb2Operations.PutItem), (Object)message, (Map)new HashMap<String, Object>(){
            {
                this.put("CamelAwsDdbConsistentRead", true);
                this.put("CamelAwsDdbItem", item);
            }
        });
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @Path(value="/item/{key}")
    @GET
    @Produces(value={"text/plain"})
    public String getItem(@PathParam(value="key") String key) {
        Map item = (Map)this.producerTemplate.send(this.componentUri(Ddb2Operations.GetItem), e -> {
            e.getMessage().setHeader("CamelAwsDdbConsistentRead", (Object)true);
            e.getMessage().setHeader("CamelAwsDdbAttributeNames", new HashSet<String>(Arrays.asList("key", "value")));
            e.getMessage().setHeader("CamelAwsDdbKey", Collections.singletonMap("key", (AttributeValue)AttributeValue.builder().s(key).build()));
        }).getMessage().getHeader("CamelAwsDdbAttributes", Map.class);
        AttributeValue val = (AttributeValue)item.get("value");
        return val == null ? null : val.s();
    }

    @Path(value="/item/{key}")
    @PUT
    @Produces(value={"text/plain"})
    public void updateItem(final String message, final @PathParam(value="key") String key, @QueryParam(value="table") String table) throws Exception {
        this.producerTemplate.sendBodyAndHeaders(this.componentUri(Table.valueOf(table), Ddb2Operations.UpdateItem), null, (Map)new HashMap<String, Object>(){
            {
                this.put("CamelAwsDdbKey", Collections.singletonMap("key", (AttributeValue)AttributeValue.builder().s(key).build()));
                this.put("CamelAwsDdbUpdateValues", Collections.singletonMap("value", (AttributeValueUpdate)AttributeValueUpdate.builder().action(AttributeAction.PUT).value((AttributeValue)AttributeValue.builder().s(message).build()).build()));
            }
        });
    }

    @Path(value="/item/{key}")
    @DELETE
    @Produces(value={"text/plain"})
    public void deleteItem(final @PathParam(value="key") String key, @QueryParam(value="table") String table) throws Exception {
        this.producerTemplate.sendBodyAndHeaders(this.componentUri(Table.valueOf(table), Ddb2Operations.DeleteItem), null, (Map)new HashMap<String, Object>(){
            {
                this.put("CamelAwsDdbConsistentRead", true);
                this.put("CamelAwsDdbKey", Collections.singletonMap("key", (AttributeValue)AttributeValue.builder().s(key).build()));
            }
        });
    }

    @Path(value="/batchItems")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Map<String, String> batchItems(List<String> keyValues) {
        Map[] keyAttrs = (Map[])keyValues.stream().map(v -> Collections.singletonMap("key", (AttributeValue)AttributeValue.builder().s(v).build())).toArray(Map[]::new);
        Map<String, KeysAndAttributes> keysAttrs = Collections.singletonMap(this.operationsTableName, (KeysAndAttributes)KeysAndAttributes.builder().keys(keyAttrs).build());
        Map result = (Map)this.producerTemplate.send(this.componentUri(Table.operations, Ddb2Operations.BatchGetItems), e -> e.getIn().setHeader("CamelAwsDdbBatchItems", (Object)keysAttrs)).getMessage().getHeader("CamelAwsDdbBatchResponse");
        HashMap<String, String> collected = new HashMap<String, String>();
        for (Map m : (List)result.get(this.operationsTableName)) {
            collected.put(((AttributeValue)m.get("key")).s(), ((AttributeValue)m.get("value")).s());
        }
        return collected;
    }

    @Path(value="/query")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Map<String, String> query(String keyEq) {
        HashMap<String, Condition> keyConditions = new HashMap<String, Condition>();
        Condition.Builder condition = Condition.builder().comparisonOperator(ComparisonOperator.EQ.toString()).attributeValueList(new AttributeValue[]{(AttributeValue)AttributeValue.builder().s(keyEq).build()});
        keyConditions.put("key", (Condition)condition.build());
        List result = (List)this.producerTemplate.send(this.componentUri(Table.operations, Ddb2Operations.Query), e -> {
            e.getIn().setHeader("CamelAwsDdbAttributeNames", Stream.of("key", "value").collect(Collectors.toList()));
            e.getIn().setHeader("CamelAwsDdbConsistentRead", (Object)true);
            e.getIn().setHeader("CamelAwsDdbLimit", (Object)10);
            e.getIn().setHeader("CamelAwsDdbScanIndexForward", (Object)true);
            e.getIn().setHeader("CamelAwsDdbKeyConditions", (Object)keyConditions);
        }).getMessage().getHeader("CamelAwsDdbItems");
        HashMap<String, String> collected = new HashMap<String, String>();
        for (Map m : result) {
            collected.put(((AttributeValue)m.get("key")).s(), ((AttributeValue)m.get("value")).s());
        }
        return collected;
    }

    @Path(value="/scan")
    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Map<String, String> scan() {
        List result = (List)this.producerTemplate.send(this.componentUri(Table.operations, Ddb2Operations.Scan), e -> {
            e.getIn().setHeader("CamelAwsDdbAttributeNames", Stream.of("key", "value").collect(Collectors.toList()));
            e.getIn().setHeader("CamelAwsDdbConsistentRead", (Object)true);
        }).getMessage().getHeader("CamelAwsDdbItems");
        HashMap<String, String> collected = new HashMap<String, String>();
        for (Map m : result) {
            collected.put(((AttributeValue)m.get("key")).s(), ((AttributeValue)m.get("value")).s());
        }
        return collected;
    }

    @Path(value="/updateTable")
    @POST
    @Consumes(value={"application/json"})
    public Response updateTable(int capacity) throws Exception {
        this.producerTemplate.send(this.componentUri(Table.operations, Ddb2Operations.UpdateTable), e -> {
            e.getIn().setHeader("CamelAwsDdbReadCapacity", (Object)capacity);
            e.getIn().setHeader("CamelAwsDdbWriteCapacity", (Object)capacity);
        });
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @Path(value="/operation")
    @POST
    @Produces(value={"application/json"})
    public Map<String, Object> operation(String operation) {
        Message message = this.producerTemplate.send(this.componentUri(Table.operations, Ddb2Operations.valueOf((String)operation)), e -> {}).getMessage();
        return message.getHeaders().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            if (e.getValue() instanceof List) {
                return ((List)e.getValue()).size();
            }
            if (e.getValue() instanceof ProvisionedThroughputDescription) {
                ProvisionedThroughputDescription ptd = (ProvisionedThroughputDescription)e.getValue();
                return CollectionHelper.mapOf((Object)"CamelAwsDdbReadCapacity", (Object)ptd.readCapacityUnits(), (Object[])new Object[]{"CamelAwsDdbWriteCapacity", ptd.writeCapacityUnits()});
            }
            if ("CamelAwsDdbTableName".equals(e.getKey()) && this.operationsTableName.equals(e.getValue())) {
                return Table.operations.toString();
            }
            return e.getValue() == null ? "" : e.getValue().toString();
        }));
    }

    private String componentUri(Ddb2Operations op) {
        return this.componentUri(Table.basic, op);
    }

    private String componentUri(Table table, Ddb2Operations op) {
        String tableName;
        switch (table) {
            case operations: {
                tableName = this.operationsTableName;
                break;
            }
            case stream: {
                tableName = this.streamTableName;
                break;
            }
            default: {
                tableName = this.tableName;
            }
        }
        return "aws2-ddb://" + tableName + "?operation=" + op;
    }

    public static enum Table {
        basic,
        operations,
        stream;

    }
}

