/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.ddb.it;

import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.quarkus.test.support.aws2.Aws2TestEnvContext;
import org.apache.camel.quarkus.test.support.aws2.Aws2TestEnvCustomizer;
import org.apache.commons.lang3.RandomStringUtils;
import org.testcontainers.containers.localstack.LocalStackContainer;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.services.dynamodb.model.StreamSpecification;
import software.amazon.awssdk.services.dynamodb.model.StreamViewType;
import software.amazon.awssdk.services.dynamodb.waiters.DynamoDbWaiter;

public class Aws2DdbTestEnvCustomizer
implements Aws2TestEnvCustomizer {
    public LocalStackContainer.Service[] localstackServices() {
        return new LocalStackContainer.Service[]{LocalStackContainer.Service.DYNAMODB, LocalStackContainer.Service.DYNAMODB_STREAMS};
    }

    public void customize(Aws2TestEnvContext envContext) {
        String tableName = "camel-quarkus-" + RandomStringUtils.randomAlphanumeric((int)16).toLowerCase(Locale.ROOT);
        envContext.property("aws-ddb.table-name", tableName);
        String tableNameOperations = "camel-quarkus-operations-" + RandomStringUtils.randomAlphanumeric((int)16).toLowerCase(Locale.ROOT);
        envContext.property("aws-ddb.operations-table-name", tableNameOperations);
        String tableNameStreams = "camel-quarkus-streams-" + RandomStringUtils.randomAlphanumeric((int)16).toLowerCase(Locale.ROOT);
        envContext.property("aws-ddb.stream-table-name", tableNameStreams);
        List tableNames = Stream.of(tableName, tableNameStreams, tableNameOperations).collect(Collectors.toList());
        DynamoDbClient client = (DynamoDbClient)envContext.client(LocalStackContainer.Service.DYNAMODB, DynamoDbClient::builder);
        String keyColumn = "key";
        for (String table : tableNames) {
            client.createTable((CreateTableRequest)this.createTableRequest(table, "key").build());
        }
        for (String table : tableNames) {
            try (DynamoDbWaiter dbWaiter = client.waiter();){
                dbWaiter.waitUntilTableExists((DescribeTableRequest)DescribeTableRequest.builder().tableName(table).build());
            }
            envContext.closeable(() -> client.deleteTable((DeleteTableRequest)DeleteTableRequest.builder().tableName(table).build()));
        }
    }

    private CreateTableRequest.Builder createTableRequest(String tableName, String keyColumn) {
        CreateTableRequest.Builder builder = CreateTableRequest.builder().attributeDefinitions(new AttributeDefinition[]{(AttributeDefinition)AttributeDefinition.builder().attributeName(keyColumn).attributeType(ScalarAttributeType.S).build()}).keySchema(new KeySchemaElement[]{(KeySchemaElement)KeySchemaElement.builder().attributeName(keyColumn).keyType(KeyType.HASH).build()}).provisionedThroughput((ProvisionedThroughput)ProvisionedThroughput.builder().readCapacityUnits(Long.valueOf(10L)).writeCapacityUnits(Long.valueOf(10L)).build());
        if (tableName.contains("streams")) {
            builder.streamSpecification((StreamSpecification)StreamSpecification.builder().streamEnabled(Boolean.valueOf(true)).streamViewType(StreamViewType.NEW_AND_OLD_IMAGES).build());
        }
        return builder.tableName(tableName);
    }
}

