/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.ddb.it;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.Record;
import software.amazon.awssdk.services.dynamodb.model.StreamRecord;

@ApplicationScoped
public class Aws2DdbStreamRoutes
extends RouteBuilder {
    @ConfigProperty(name="aws-ddb.stream-table-name")
    String streamTableName;
    @Inject
    @Named(value="aws2DdbStreamReceivedEvents")
    List<Map<String, String>> aws2DdbStreamReceivedEvents;

    public void configure() throws Exception {
        ((RouteDefinition)this.from("aws2-ddbstream://" + this.streamTableName + "?sequenceNumberProvider=#aws2DdbStreamSequenceNumberProvider&iteratorType=AT_SEQUENCE_NUMBER").id("aws2DdbStreamRoute")).process(e -> {
            Record record = (Record)e.getMessage().getBody(Record.class);
            StreamRecord item = record.dynamodb();
            LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
            result.put("key", ((AttributeValue)item.keys().get("key")).s());
            if (item.hasOldImage()) {
                result.put("old", ((AttributeValue)item.oldImage().get("value")).s());
            }
            if (item.hasNewImage()) {
                result.put("new", ((AttributeValue)item.newImage().get("value")).s());
            }
            result.put("sequenceNumber", item.sequenceNumber());
            this.aws2DdbStreamReceivedEvents.add(result);
        });
    }

    static class Producers {
        Producers() {
        }

        @Singleton
        @Produces
        @Named(value="aws2DdbStreamReceivedEvents")
        List<Map<String, String>> aws2DdbStreamReceivedEvents() {
            return new CopyOnWriteArrayList<Map<String, String>>();
        }
    }
}

