/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.ddb.it;

import java.util.Locale;
import org.apache.camel.quarkus.test.support.aws2.Aws2TestEnvContext;
import org.apache.camel.quarkus.test.support.aws2.Aws2TestEnvCustomizer;
import org.apache.commons.lang3.RandomStringUtils;
import org.testcontainers.containers.localstack.LocalStackContainer;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.CreateTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DeleteTableRequest;
import software.amazon.awssdk.services.dynamodb.model.DescribeTableRequest;
import software.amazon.awssdk.services.dynamodb.model.KeySchemaElement;
import software.amazon.awssdk.services.dynamodb.model.KeyType;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughput;
import software.amazon.awssdk.services.dynamodb.model.ScalarAttributeType;
import software.amazon.awssdk.services.dynamodb.model.StreamSpecification;
import software.amazon.awssdk.services.dynamodb.model.StreamViewType;
import software.amazon.awssdk.services.dynamodb.waiters.DynamoDbWaiter;

public class Aws2DdbTestEnvCustomizer
implements Aws2TestEnvCustomizer {
    public LocalStackContainer.Service[] localstackServices() {
        return new LocalStackContainer.Service[]{LocalStackContainer.Service.DYNAMODB, LocalStackContainer.Service.DYNAMODB_STREAMS};
    }

    public void customize(Aws2TestEnvContext envContext) {
        String tableName = "camel-quarkus-" + RandomStringUtils.randomAlphanumeric((int)16).toLowerCase(Locale.ROOT);
        envContext.property("aws-ddb.table-name", tableName);
        DynamoDbClient client = (DynamoDbClient)envContext.client(LocalStackContainer.Service.DYNAMODB, DynamoDbClient::builder);
        String keyColumn = "key";
        client.createTable((CreateTableRequest)CreateTableRequest.builder().attributeDefinitions(new AttributeDefinition[]{(AttributeDefinition)AttributeDefinition.builder().attributeName("key").attributeType(ScalarAttributeType.S).build()}).keySchema(new KeySchemaElement[]{(KeySchemaElement)KeySchemaElement.builder().attributeName("key").keyType(KeyType.HASH).build()}).provisionedThroughput((ProvisionedThroughput)ProvisionedThroughput.builder().readCapacityUnits(new Long(10L)).writeCapacityUnits(new Long(10L)).build()).streamSpecification((StreamSpecification)StreamSpecification.builder().streamEnabled(Boolean.valueOf(true)).streamViewType(StreamViewType.NEW_AND_OLD_IMAGES).build()).tableName(tableName).build());
        try (DynamoDbWaiter dbWaiter = client.waiter();){
            dbWaiter.waitUntilTableExists((DescribeTableRequest)DescribeTableRequest.builder().tableName(tableName).build());
        }
        envContext.closeable(() -> client.deleteTable((DeleteTableRequest)DeleteTableRequest.builder().tableName(tableName).build()));
    }
}

