/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.ddb.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.ExtractableResponse;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.camel.quarkus.test.support.aws2.Aws2TestResource;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable;

@QuarkusTest
@QuarkusTestResource(value=Aws2TestResource.class)
@EnabledIfEnvironmentVariable(named="AWS_ACCESS_KEY", matches="[a-zA-Z0-9]+")
class Aws2DdbTest {
    private static final Logger LOG = Logger.getLogger(Aws2DdbTest.class);

    Aws2DdbTest() {
    }

    @Test
    public void crud() {
        String key = "key" + UUID.randomUUID().toString().replace("-", "");
        String msg = "val" + UUID.randomUUID().toString().replace("-", "");
        ((ValidatableResponse)RestAssured.get((String)("/aws2-ddb/item/" + key), (Object[])new Object[0]).then()).statusCode(204);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body(msg).post("/aws2-ddb/item/" + key, new Object[0])).then()).statusCode(201);
        Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
            ExtractableResponse result = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/aws2-ddb/item/" + key), (Object[])new Object[0]).then()).statusCode((Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)200), (Matcher)Matchers.is((Object)204)))).extract();
            LOG.info((Object)("Expecting " + msg + " got " + result.statusCode() + ": " + result.body().asString()));
            return result.body().asString();
        }, Matchers.is((Object)msg));
        String newMsg = "newVal" + UUID.randomUUID().toString().replace("-", "");
        ((ValidatableResponse)((Response)RestAssured.given().body(newMsg).put("/aws2-ddb/item/" + key, new Object[0])).then()).statusCode(204);
        Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
            ExtractableResponse result = ((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)("/aws2-ddb/item/" + key), (Object[])new Object[0]).then()).statusCode((Matcher)Matchers.anyOf((Matcher)Matchers.is((Object)200), (Matcher)Matchers.is((Object)204)))).extract();
            LOG.info((Object)("Expecting " + newMsg + " got " + result.statusCode() + ": " + result.body().asString()));
            return result.body().asString();
        }, Matchers.is((Object)newMsg));
        ((ValidatableResponse)((Response)RestAssured.given().delete("/aws2-ddb/item/" + key, new Object[0])).then()).statusCode(204);
        Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
            ExtractableResponse result = ((ValidatableResponse)RestAssured.get((String)("/aws2-ddb/item/" + key), (Object[])new Object[0]).then()).extract();
            LOG.info((Object)("Expecting " + msg + " got " + result.statusCode() + ": " + result.body().asString()));
            return result.statusCode();
        }, Matchers.is((Object)204));
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/aws2-ddbstream/change", (Object[])new Object[0]).then()).statusCode(200)).body("key", Matchers.is((Object)key), new Object[0])).body("new", Matchers.is((Object)msg), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/aws2-ddbstream/change", (Object[])new Object[0]).then()).statusCode(200)).body("key", Matchers.is((Object)key), new Object[0])).body("old", Matchers.is((Object)msg), new Object[0])).body("new", Matchers.is((Object)newMsg), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)RestAssured.get((String)"/aws2-ddbstream/change", (Object[])new Object[0]).then()).statusCode(200)).body("key", Matchers.is((Object)key), new Object[0])).body("old", Matchers.is((Object)newMsg), new Object[0]);
    }
}

