/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.cw.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.camel.quarkus.test.support.aws2.Aws2Client;
import org.apache.camel.quarkus.test.support.aws2.Aws2TestResource;
import org.apache.camel.quarkus.test.support.aws2.BaseAWs2TestSupport;
import org.apache.camel.util.CollectionHelper;
import org.awaitility.Awaitility;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Test;
import org.testcontainers.containers.localstack.LocalStackContainer;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.model.Datapoint;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsRequest;
import software.amazon.awssdk.services.cloudwatch.model.Statistic;

@QuarkusTest
@QuarkusTestResource(value=Aws2TestResource.class)
class Aws2CwTest
extends BaseAWs2TestSupport {
    private static final Logger LOG = Logger.getLogger(Aws2CwTest.class);
    @Aws2Client(value=LocalStackContainer.Service.CLOUDWATCH)
    CloudWatchClient client;

    public Aws2CwTest() {
        super("/aws2-cw");
    }

    public void testMethodForDefaultCredentialsProvider() {
        String namespace = "cq-metrics-" + UUID.randomUUID().toString().replace("-", "");
        String metricName = "metricName" + UUID.randomUUID().toString().replace("-", "");
        Map item = CollectionHelper.mapOf((Object)"CamelAwsCwMetricNamespace", (Object)namespace, (Object[])new Object[]{"CamelAwsCwMetricName", metricName, "CamelAwsCwMetricValue", 0, "CamelAwsCwMetricUnit", "Count", "CamelAwsCwMetricDimensionName", "type", "CamelAwsCwMetricDimensionValue", "even"});
        ((ValidatableResponse)((Response)RestAssured.given().contentType("application/x-www-form-urlencoded; charset=utf-8").formParams(item).post("/aws2-cw/send-metric-map/" + namespace, new Object[0])).then()).statusCode(201);
    }

    @Test
    public void metric() {
        Instant startTime = Instant.ofEpochMilli(System.currentTimeMillis() - 10000L);
        String namespace = "cq-metrics-" + UUID.randomUUID().toString().replace("-", "");
        String metricName = "metricName" + UUID.randomUUID().toString().replace("-", "");
        int value = (int)(Math.random() * 10000.0);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body((Object)value).post("/aws2-cw/send-metric/" + namespace + "/" + metricName + "/Count", new Object[0])).then()).statusCode(201);
        double precision = 1.0E-4;
        Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
            List datapoints = this.client.getMetricStatistics((GetMetricStatisticsRequest)GetMetricStatisticsRequest.builder().namespace(namespace).metricName(metricName).statistics(new Statistic[]{Statistic.SAMPLE_COUNT, Statistic.MINIMUM, Statistic.MAXIMUM}).startTime(startTime).endTime(Instant.ofEpochMilli(System.currentTimeMillis() + 10000L)).period(Integer.valueOf(1)).build()).datapoints();
            LOG.info((Object)("Expecting some datapoints for metric " + namespace + "/" + metricName + ", got " + datapoints));
            if (datapoints.isEmpty()) {
                return false;
            }
            Datapoint dp = (Datapoint)datapoints.get(0);
            if (dp.sampleCount() + 1.0E-4 > 1.0 && Math.abs(dp.minimum() - (double)value) < 1.0E-4 && Math.abs(dp.maximum() - (double)value) < 1.0E-4) {
                return true;
            }
            throw new RuntimeException("Unexpected datapoint " + dp + "; expected sampleCount ~ 1 && minimum ~ " + value + " && maximum ~ " + value);
        });
    }

    @Test
    public void headers() {
        Instant startTime = Instant.ofEpochMilli(System.currentTimeMillis() - 10000L);
        String namespace = "cq-metrics-" + UUID.randomUUID().toString().replace("-", "");
        String metricName = "metricName" + UUID.randomUUID().toString().replace("-", "");
        int value = (int)(Math.random() * 10000.0);
        LinkedList<Map> data = new LinkedList<Map>();
        data.add(CollectionHelper.mapOf((Object)"CamelAwsCwMetricNamespace", (Object)namespace, (Object[])new Object[]{"CamelAwsCwMetricName", metricName, "CamelAwsCwMetricValue", 2 * value, "CamelAwsCwMetricUnit", "Count", "CamelAwsCwMetricDimensionName", "type", "CamelAwsCwMetricDimensionValue", "even"}));
        data.add(CollectionHelper.mapOf((Object)"CamelAwsCwMetricNamespace", (Object)namespace, (Object[])new Object[]{"CamelAwsCwMetricName", metricName, "CamelAwsCwMetricValue", 2 * value + 2, "CamelAwsCwMetricUnit", "Count", "CamelAwsCwMetricDimensions", "type=even"}));
        data.add(CollectionHelper.mapOf((Object)"CamelAwsCwMetricNamespace", (Object)namespace, (Object[])new Object[]{"CamelAwsCwMetricName", metricName, "CamelAwsCwMetricValue", 2 * value + 4, "CamelAwsCwMetricUnit", "Count", "CamelAwsCwMetricDimensionName", "type", "CamelAwsCwMetricDimensionValue", "even"}));
        data.add(CollectionHelper.mapOf((Object)"CamelAwsCwMetricNamespace", (Object)namespace, (Object[])new Object[]{"CamelAwsCwMetricName", metricName, "CamelAwsCwMetricValue", 2 * value + 1, "CamelAwsCwMetricUnit", "Count", "CamelAwsCwMetricDimensionName", "type", "CamelAwsCwMetricDimensionValue", "odd"}));
        data.add(CollectionHelper.mapOf((Object)"CamelAwsCwMetricNamespace", (Object)namespace, (Object[])new Object[]{"CamelAwsCwMetricName", metricName, "CamelAwsCwMetricValue", 2 * value + 3, "CamelAwsCwMetricUnit", "Count", "CamelAwsCwMetricDimensionName", "type", "CamelAwsCwMetricDimensionValue", "odd"}));
        data.add(CollectionHelper.mapOf((Object)"CamelAwsCwMetricNamespace", (Object)namespace, (Object[])new Object[]{"CamelAwsCwMetricName", metricName, "CamelAwsCwMetricValue", 2 * value + 5, "CamelAwsCwMetricTimestamp", System.currentTimeMillis() - 86400000L, "CamelAwsCwMetricUnit", "Count", "CamelAwsCwMetricDimensionName", "type", "CamelAwsCwMetricDimensionValue", "odd"}));
        for (Map item : data) {
            ((ValidatableResponse)((Response)RestAssured.given().contentType("application/x-www-form-urlencoded; charset=utf-8").formParams(item).post("/aws2-cw/send-metric-map/" + namespace, new Object[0])).then()).statusCode(201);
        }
        Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
            List oddDatapoints = this.client.getMetricStatistics((GetMetricStatisticsRequest)GetMetricStatisticsRequest.builder().namespace(namespace).metricName(metricName).statistics(new Statistic[]{Statistic.SAMPLE_COUNT, Statistic.MINIMUM, Statistic.MAXIMUM}).startTime(startTime).dimensions(new Dimension[]{(Dimension)Dimension.builder().name("type").value("odd").build()}).endTime(Instant.ofEpochMilli(System.currentTimeMillis() + 10000L)).period(Integer.valueOf(30)).build()).datapoints();
            List evenDatapoints = this.client.getMetricStatistics((GetMetricStatisticsRequest)GetMetricStatisticsRequest.builder().namespace(namespace).metricName(metricName).statistics(new Statistic[]{Statistic.SAMPLE_COUNT, Statistic.AVERAGE}).startTime(startTime).dimensions(new Dimension[]{(Dimension)Dimension.builder().name("type").value("even").build()}).endTime(Instant.ofEpochMilli(System.currentTimeMillis() + 10000L)).period(Integer.valueOf(30)).build()).datapoints();
            LOG.debug((Object)("Expecting some datapoints for metric " + namespace + "/" + metricName + " (type='odd'), got " + oddDatapoints));
            if (oddDatapoints.isEmpty()) {
                return false;
            }
            LOG.debug((Object)("Expecting some datapoints for metric " + namespace + "/" + metricName + " (type='even'), got " + evenDatapoints));
            if (evenDatapoints.isEmpty()) {
                return false;
            }
            Datapoint oddDp = (Datapoint)oddDatapoints.get(0);
            Datapoint evenDp = (Datapoint)evenDatapoints.get(0);
            if (oddDp.sampleCount().intValue() != 2 || oddDp.minimum().intValue() != 2 * value + 1 || oddDp.maximum().intValue() != 2 * value + 3) {
                throw new RuntimeException("Unexpected odd datapoint " + oddDp + "; expected sampleCount == 2 && minimum ~ " + (2 * value + 1) + " && maximum ~ " + (2 * value + 3));
            }
            if (evenDp.average() != (double)(2 * value + 2) || evenDp.sampleCount() != 3.0) {
                throw new RuntimeException("Unexpected even datapoint " + evenDp + "; expected sampleCount == 3 && average == " + (2 * value + 2));
            }
            return true;
        });
    }

    @Test
    public void customClient() {
        String namespace = "cq-metrics-" + UUID.randomUUID().toString().replace("-", "");
        String metricName = "metricName" + UUID.randomUUID().toString().replace("-", "");
        int value = (int)(Math.random() * 10000.0);
        Map data = CollectionHelper.mapOf((Object)"CamelAwsCwMetricNamespace", (Object)namespace, (Object[])new Object[]{"CamelAwsCwMetricName", metricName, "CamelAwsCwMetricValue", 2 * value, "CamelAwsCwMetricUnit", "Count"});
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType("application/x-www-form-urlencoded; charset=utf-8").header("customClientName", (Object)"customClient", new Object[0]).header("returnExceptionMessage", (Object)true, new Object[0]).formParams(data).post("/aws2-cw/send-metric-map/" + namespace, new Object[0])).then()).statusCode(200)).body(Matchers.is((Object)"CloudWatchClientMock"), new Matcher[0]);
    }
}

