/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.cw.it;

import io.quarkus.scheduler.Scheduled;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.quarkus.test.support.aws2.BaseAws2Resource;

@Path(value="/aws2-cw")
@ApplicationScoped
public class Aws2CwResource
extends BaseAws2Resource {
    @Inject
    ProducerTemplate producerTemplate;
    private volatile String endpointUri;

    public Aws2CwResource() {
        super("cw");
    }

    @Scheduled(every="1s")
    void schedule() {
        if (this.endpointUri != null) {
            this.producerTemplate.requestBody(this.endpointUri, null, String.class);
        }
    }

    @Path(value="/send-metric/{namespace}/{metric-name}/{metric-unit}")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response post(String value, @PathParam(value="namespace") String namespace, @PathParam(value="metric-name") String name, @PathParam(value="metric-unit") String unit) throws Exception {
        this.endpointUri = "aws2-cw://" + namespace + "?name=" + name + "&value=" + value + "&unit=" + unit;
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }

    @Path(value="/send-metric-map/{namespace}")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"text/plain"})
    public Response postMap(@PathParam(value="namespace") String namespace, @HeaderParam(value="returnExceptionMessage") boolean returnExceptionMessage, @HeaderParam(value="customClientName") String customClientName, MultivaluedMap<String, String> formParams) throws Exception {
        String uri = "aws2-cw://" + namespace + "?useDefaultCredentialsProvider=" + this.isUseDefaultCredentials();
        if (customClientName != null && !customClientName.isEmpty()) {
            uri = uri + "&autowiredEnabled=false&amazonCwClient=#" + customClientName;
        }
        Map<String, Object> typedHeaders = formParams.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> {
            String val = (String)((List)e.getValue()).get(0);
            if ("CamelAwsCwMetricTimestamp".equals(e.getKey())) {
                return Instant.ofEpochMilli(Long.parseLong(val));
            }
            if ("CamelAwsCwMetricValue".equals(e.getKey())) {
                return Long.parseLong(val);
            }
            if ("CamelAwsCwMetricDimensions".equals(e.getKey())) {
                String[] keyVal = val.split("=");
                return Map.of(keyVal[0], keyVal[1]);
            }
            return val;
        }));
        try {
            this.producerTemplate.requestBodyAndHeaders(uri, null, typedHeaders, String.class);
        }
        catch (Exception e2) {
            if (returnExceptionMessage && e2 instanceof CamelExecutionException && e2.getCause() != null) {
                return Response.ok((Object)e2.getCause().getMessage()).build();
            }
            throw e2;
        }
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }
}

