/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.cw.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.camel.quarkus.test.support.aws2.Aws2Client;
import org.apache.camel.quarkus.test.support.aws2.Aws2TestResource;
import org.awaitility.Awaitility;
import org.jboss.logging.Logger;
import org.junit.jupiter.api.Test;
import org.testcontainers.containers.localstack.LocalStackContainer;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.model.Datapoint;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsRequest;
import software.amazon.awssdk.services.cloudwatch.model.Statistic;

@QuarkusTest
@QuarkusTestResource(value=Aws2TestResource.class)
class Aws2CwTest {
    private static final Logger LOG = Logger.getLogger(Aws2CwTest.class);
    @Aws2Client(value=LocalStackContainer.Service.CLOUDWATCH)
    CloudWatchClient client;

    Aws2CwTest() {
    }

    @Test
    public void metric() {
        Instant startTime = Instant.ofEpochMilli(System.currentTimeMillis() - 10000L);
        String namespace = "cq-metrics-" + UUID.randomUUID().toString().replace("-", "");
        String metricName = "metricName" + UUID.randomUUID().toString().replace("-", "");
        int value = (int)(Math.random() * 10000.0);
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.TEXT).body((Object)value).post("/aws2-cw/send-metric/" + namespace + "/" + metricName + "/Count", new Object[0])).then()).statusCode(201);
        double precision = 1.0E-4;
        Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(120L, TimeUnit.SECONDS).until(() -> {
            List datapoints = this.client.getMetricStatistics((GetMetricStatisticsRequest)GetMetricStatisticsRequest.builder().namespace(namespace).metricName(metricName).statistics(new Statistic[]{Statistic.SAMPLE_COUNT, Statistic.MINIMUM, Statistic.MAXIMUM}).startTime(startTime).endTime(Instant.ofEpochMilli(System.currentTimeMillis() + 10000L)).period(Integer.valueOf(1)).build()).datapoints();
            LOG.info((Object)("Expecting some datapoints for metric " + namespace + "/" + metricName + ", got " + datapoints));
            if (datapoints.isEmpty()) {
                return false;
            }
            Datapoint dp = (Datapoint)datapoints.get(0);
            if (dp.sampleCount() + 1.0E-4 > 1.0 && Math.abs(dp.minimum() - (double)value) < 1.0E-4 && Math.abs(dp.maximum() - (double)value) < 1.0E-4) {
                return true;
            }
            throw new RuntimeException("Unexpected datapoint " + dp + "; expected sampleCount ~ 1 && minimum ~ " + value + " && maximum ~ " + value);
        });
    }
}

