/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.aws2.cw.it;

import io.quarkus.scheduler.Scheduled;
import java.net.URI;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.camel.ProducerTemplate;

@Path(value="/aws2-cw")
@ApplicationScoped
public class Aws2CwResource {
    @Inject
    ProducerTemplate producerTemplate;
    private volatile String endpointUri;

    @Scheduled(every="1s")
    void schedule() {
        if (this.endpointUri != null) {
            this.producerTemplate.requestBody(this.endpointUri, null, String.class);
        }
    }

    @Path(value="/send-metric/{namespace}/{metric-name}/{metric-unit}")
    @POST
    @Consumes(value={"text/plain"})
    @Produces(value={"text/plain"})
    public Response post(String value, @PathParam(value="namespace") String namespace, @PathParam(value="metric-name") String name, @PathParam(value="metric-unit") String unit) throws Exception {
        this.endpointUri = "aws2-cw://" + namespace + "?name=" + name + "&value=" + value + "&unit=" + unit;
        return Response.created((URI)new URI("https://camel.apache.org/")).build();
    }
}

