/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.atlasmap.it;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.test.common.http.TestHTTPEndpoint;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.camel.quarkus.component.atlasmap.it.AtlasmapResource;
import org.apache.camel.quarkus.component.atlasmap.it.model.Account;
import org.apache.camel.quarkus.component.atlasmap.it.model.Person;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
@TestHTTPEndpoint(value=AtlasmapResource.class)
class AtlasmapTest {
    AtlasmapTest() {
    }

    @Test
    void testJava2JsonWithJson() {
        Person person = new Person("foo", "bar", 35);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(AtlasmapTest.toJson(person)).when().get("/json/java2json", new Object[0])).then()).body("name1", Matchers.equalTo((Object)"foo"), new Object[0])).body("name2", Matchers.equalTo((Object)"bar"), new Object[0])).body("age", Matchers.equalTo((Object)35), new Object[0]);
    }

    @Test
    void testJson2JavaWithJson() {
        String person = "{\"name1\":\"foo\", \"name2\":\"bar\", \"age\":35}";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(person).when().get("/json/json2java", new Object[0])).then()).body("firstName", Matchers.equalTo((Object)"foo"), new Object[0])).body("lastName", Matchers.equalTo((Object)"bar"), new Object[0])).body("age", Matchers.equalTo((Object)35), new Object[0]);
    }

    @Test
    void testXml2XmlWithJson() {
        String request = "<tns:Patient xmlns:tns=\"http://hl7.org/fhir\"><tns:id value=\"101138\"></tns:id></tns:Patient>";
        String expectedResponse = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><tns:Person xmlns:tns=\"http://hl7.org/fhir\"><tns:id value=\"101138\"/></tns:Person>";
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(request).when().get("/json/xml2xml", new Object[0])).then()).body(Matchers.equalTo((Object)expectedResponse), new Matcher[0]);
    }

    @Test
    void testJson2XmlWithJson() {
        String request = "{\"id\":\"101138\"}";
        String expectedResponse = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><tns:Person xmlns:tns=\"http://hl7.org/fhir\"><tns:id value=\"101138\"/></tns:Person>";
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(request).when().get("/json/json2xml", new Object[0])).then()).body(Matchers.equalTo((Object)expectedResponse), new Matcher[0]);
    }

    @Test
    void testXml2JsonWithJson() {
        String request = "<tns:Patient xmlns:tns=\"http://hl7.org/fhir\"><tns:id value=\"101138\"></tns:id></tns:Patient>";
        String expectedResponse = "{\"id\":\"101138\"}";
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(request).when().get("/json/xml2json", new Object[0])).then()).body(Matchers.equalTo((Object)expectedResponse), new Matcher[0]);
    }

    @Test
    void testJava2XmlWithJson() {
        Person request = new Person("foo", "bar", 35);
        String expectedResponse = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><tns:Person xmlns:tns=\"http://hl7.org/fhir\"><tns:firstName value=\"foo\"/><tns:lastName value=\"bar\"/><tns:age value=\"35\"/></tns:Person>";
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(AtlasmapTest.toJson(request)).when().get("/json/java2xml", new Object[0])).then()).body(Matchers.equalTo((Object)expectedResponse), new Matcher[0]);
    }

    static String toJson(Object request) {
        try {
            return new ObjectMapper().writeValueAsString(request);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Could not serialize " + request.getClass().getName() + " " + request, e);
        }
    }

    @Test
    void testXml2JavaWithJson() {
        String request = "<tns:Person xmlns:tns=\"http://hl7.org/fhir\"><tns:firstName value=\"foo\"/><tns:lastName value=\"bar\"/><tns:age value=\"35\"/></tns:Person>";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(request).when().get("/json/xml2java", new Object[0])).then()).body("firstName", Matchers.equalTo((Object)"foo"), new Object[0])).body("lastName", Matchers.equalTo((Object)"bar"), new Object[0])).body("age", Matchers.equalTo((Object)35), new Object[0]);
    }

    @Test
    void testXml2XmlWithAdm() {
        String request = "<tns:Patient xmlns:tns=\"http://hl7.org/fhir\"><tns:id>101138</tns:id></tns:Patient>";
        String expectedResponse = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><tns:Person xmlns:tns=\"http://hl7.org/fhir\"><tns:id>101138</tns:id></tns:Person>";
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(request).when().get("/adm/xml2xml", new Object[0])).then()).body(Matchers.equalTo((Object)expectedResponse), new Matcher[0]);
    }

    @Test
    void testJson2JsonWithAdm() {
        String request = "{\"name1\":\"foo\", \"name2\":\"bar\", \"age\":35}";
        String expectedResponse = "{\"age\":35,\"firstName\":\"foo\",\"lastName\":\"bar\"}";
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(request).when().get("/adm/json2json", new Object[0])).then()).body(Matchers.equalTo((Object)expectedResponse), new Matcher[0]);
    }

    @Test
    void testXml2JsonWithAdm() {
        String request = "<tns:Patient xmlns:tns=\"http://hl7.org/fhir\"><tns:id>101138</tns:id></tns:Patient>";
        String expectedResponse = "{\"id\":\"101138\"}";
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(request).when().get("/adm/xml2json", new Object[0])).then()).body(Matchers.equalTo((Object)expectedResponse), new Matcher[0]);
    }

    @Test
    void testJson2XmlWithAdm() {
        String request = "{\"id\":\"101138\"}";
        String expectedResponse = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><tns:Patient xmlns:tns=\"http://hl7.org/fhir\"><tns:id>101138</tns:id></tns:Patient>";
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(request).when().get("/adm/json2xml", new Object[0])).then()).body(Matchers.equalTo((Object)expectedResponse), new Matcher[0]);
    }

    @Test
    void testJson2CsvWithJson() {
        String person = "{\"name1\":\"foo\", \"name2\":\"bar\", \"age\":35}";
        String experctedResult = "firstName,lastName,age\r\nfoo,bar,35\r\n";
        String result = ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(person).when().get("/json/json2csv", new Object[0])).then()).extract().asString();
        Assertions.assertEquals((Object)experctedResult, (Object)result);
    }

    @Test
    void testCsv2JsonWithAdm() {
        String request = "foo,bar,35\r\n";
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(request).when().get("/adm/csv2json", new Object[0])).then()).body(Matchers.equalTo((Object)"{\"firstName\":\"foo\",\"lastName\":\"bar\",\"age\":35}"), new Matcher[0]);
    }

    @Test
    void testCsv2JsonWithJson() {
        String request = "firstName,lastName,age\r\nfoo,bar,35\r\n";
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(request).when().get("/json/csv2json", new Object[0])).then()).body(Matchers.equalTo((Object)"{\"firstName\":\"foo\",\"lastName\":\"bar\",\"age\":\"35\"}"), new Matcher[0]);
    }

    @Test
    void testCsv2JavaWithJson() {
        String request = "id,userName\r\n1,user\r\n";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(request).when().post("/json/csv2java", new Object[0])).then()).body("id", Matchers.equalTo((Object)"1"), new Object[0])).body("userName", Matchers.equalTo((Object)"user"), new Object[0]);
    }

    @Test
    void testCsv2XmlWithJson() {
        String request = "firstName,lastName,age\r\nfoo,bar,35\r\n";
        String expectedResult = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><tns:Person xmlns:tns=\"http://hl7.org/fhir\"><tns:firstName value=\"foo\"/><tns:lastName value=\"bar\"/><tns:age value=\"35\"/></tns:Person>";
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(request).when().get("/json/csv2xml", new Object[0])).then()).body(Matchers.equalTo((Object)expectedResult), new Matcher[0]);
    }

    @Test
    void testXml2CsvWithJson() {
        String request = "<tns:Person xmlns:tns=\"http://hl7.org/fhir\"><tns:firstName value=\"foo\"/><tns:lastName value=\"bar\"/><tns:age value=\"35\"/></tns:Person>";
        String expectedResult = "firstName,lastName,age\r\nfoo,bar,35\r\n";
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(request).when().get("/json/xml2csv", new Object[0])).then()).body(Matchers.equalTo((Object)expectedResult), new Matcher[0]);
    }

    @Test
    void testJava2CsvWithJson() {
        String expectedResult = "id,userName\r\n1,user\r\n";
        Account person = new Account("1", "user");
        ((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body(AtlasmapTest.toJson(person)).when().post("/json/java2csv", new Object[0])).then()).body(Matchers.equalTo((Object)expectedResult), new Matcher[0]);
    }

    @Test
    void testGetAtlasMapVersion() throws IOException {
        try (InputStream stream = this.getClass().getResourceAsStream("/atlasmap.properties");){
            Properties properties = new Properties();
            properties.load(stream);
            String version = properties.getProperty("atlasmap.core.version");
            ((ValidatableResponse)((Response)RestAssured.given().get("/version", new Object[0])).then()).body(Matchers.equalTo((Object)version), new Matcher[0]);
        }
    }
}

