/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.as2.it.transport;

import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.component.as2.api.AS2EncryptionAlgorithm;
import org.apache.camel.component.as2.api.AS2MessageStructure;
import org.apache.camel.component.as2.api.AS2SignatureAlgorithm;
import org.apache.camel.quarkus.component.as2.it.As2CertificateHelper;
import org.apache.http.entity.ContentType;

public class Request {
    private AS2MessageStructure messageStructure;
    private String messageStructureKey;
    private ContentType contentType;
    private String contentTypeKey;
    private Map<String, Object> headers = new HashMap<String, Object>();
    private String ediMessage;
    private AS2EncryptionAlgorithm encryptionAlgorithm;
    private AS2SignatureAlgorithm signingAlgorithm;

    public Request() {
    }

    public Request(String ediMessage) {
        this.ediMessage = ediMessage;
    }

    public AS2MessageStructure getMessageStructure() {
        return this.messageStructure;
    }

    public void setMessageStructure(AS2MessageStructure messageStructure) {
        this.messageStructure = messageStructure;
    }

    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    public void addField(String key, Object value) {
        this.headers.put(key, value);
    }

    public void setHeaders(Map<String, Object> headers) {
        this.headers = headers;
    }

    public String getMessageStructureKey() {
        return this.messageStructureKey;
    }

    public void setMessageStructureKey(String messageStructureKey) {
        this.messageStructureKey = messageStructureKey;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public String getContentTypeKey() {
        return this.contentTypeKey;
    }

    public void setContentTypeKey(String contentTypeKey) {
        this.contentTypeKey = contentTypeKey;
    }

    public String getEdiMessage() {
        return this.ediMessage;
    }

    public Request withEdiMessage(String ediMessage) {
        this.ediMessage = ediMessage;
        return this;
    }

    public Request withHeaders(Map<String, Object> headers) {
        this.headers = headers;
        for (Map.Entry<String, Object> entry : headers.entrySet()) {
            if (!(entry.getValue() instanceof AS2MessageStructure)) continue;
            this.setMessageStructure((AS2MessageStructure)entry.getValue());
            this.setMessageStructureKey(entry.getKey());
        }
        return this;
    }

    public Map<String, Object> collectHeaders() {
        HashMap<String, Object> retVal = new HashMap<String, Object>(this.headers);
        if (this.getMessageStructure() != null) {
            retVal.put(this.getMessageStructureKey(), this.getMessageStructure());
        }
        retVal.put("CamelAS2.ediMessageContentType", ContentType.create((String)"application/edifact", (String)"US-ASCII"));
        if (this.getEncryptionAlgorithm() != null) {
            retVal.put("CamelAS2.encryptingCertificateChain", As2CertificateHelper.getCertList());
            retVal.put("CamelAS2.encryptingAlgorithm", this.getEncryptionAlgorithm());
        }
        if (this.getSigningAlgorithm() != null) {
            retVal.put("CamelAS2.signingCertificateChain", As2CertificateHelper.getCertList().toArray(new Certificate[0]));
            retVal.put("CamelAS2.signingPrivateKey", As2CertificateHelper.getSigningKP().getPrivate());
            retVal.put("CamelAS2.signingAlgorithm", this.getSigningAlgorithm());
        }
        return retVal;
    }

    public AS2EncryptionAlgorithm getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public Request withEncryptionAlgorithm(AS2EncryptionAlgorithm encryptionAlgorithm) {
        this.encryptionAlgorithm = encryptionAlgorithm;
        return this;
    }

    public AS2SignatureAlgorithm getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public Request withSigningAlgorithm(AS2SignatureAlgorithm signingAlgorithm) {
        this.signingAlgorithm = signingAlgorithm;
        return this;
    }
}

