/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.as2.it;

import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.camel.component.as2.api.AS2ClientConnection;
import org.apache.camel.component.as2.api.AS2ClientManager;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.bc.BcX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

public class As2CertificateHelper {
    private static final String TARGET_HOST = "localhost";
    private static final String AS2_VERSION = "1.1";
    private static final String USER_AGENT = "Camel AS2 Endpoint";
    private static final String CLIENT_FQDN = "example.org";
    private static KeyPair signingKP;
    private static X509Certificate signingCert;
    private static List<X509Certificate> certList;
    static int serialNo;

    private As2CertificateHelper() {
    }

    public static void setup() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("RSA", "BC");
        kpg.initialize(1024, new SecureRandom());
        String issueDN = "O=Earth 2 Software, C=E2";
        KeyPair issueKP = kpg.generateKeyPair();
        X509Certificate issueCert = As2CertificateHelper.makeCertificate(issueKP, issueDN, issueKP, issueDN);
        String signingDN = "CN=Shekdon, E=test@gmail.com, O=Earth 2 Software, C=E2";
        signingKP = kpg.generateKeyPair();
        signingCert = As2CertificateHelper.makeCertificate(signingKP, signingDN, issueKP, issueDN);
        certList = new ArrayList<X509Certificate>();
        certList.add(signingCert);
        certList.add(issueCert);
    }

    public static X509Certificate makeCertificate(KeyPair subKP, String subDN, KeyPair issKP, String issDN) throws GeneralSecurityException, IOException, OperatorCreationException {
        PublicKey subPub = subKP.getPublic();
        PrivateKey issPriv = issKP.getPrivate();
        PublicKey issPub = issKP.getPublic();
        JcaX509v3CertificateBuilder v3CertGen = new JcaX509v3CertificateBuilder(new X500Name(issDN), BigInteger.valueOf(serialNo++), new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis() + 8640000000L), new X500Name(subDN), subPub);
        v3CertGen.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)As2CertificateHelper.createSubjectKeyId(subPub));
        v3CertGen.addExtension(Extension.authorityKeyIdentifier, false, (ASN1Encodable)As2CertificateHelper.createAuthorityKeyId(issPub));
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(v3CertGen.build(new JcaContentSignerBuilder("MD5withRSA").setProvider("BC").build(issPriv)));
    }

    public static AuthorityKeyIdentifier createAuthorityKeyId(PublicKey pub) throws IOException {
        SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance((Object)pub.getEncoded());
        BcX509ExtensionUtils utils = new BcX509ExtensionUtils();
        return utils.createAuthorityKeyIdentifier(info);
    }

    public static SubjectKeyIdentifier createSubjectKeyId(PublicKey pub) throws IOException {
        SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance((Object)pub.getEncoded());
        return new BcX509ExtensionUtils().createSubjectKeyIdentifier(info);
    }

    public static AS2ClientManager createClient(int port) throws IOException {
        AS2ClientConnection clientConnection = new AS2ClientConnection(AS2_VERSION, USER_AGENT, CLIENT_FQDN, TARGET_HOST, Integer.valueOf(port));
        return new AS2ClientManager(clientConnection);
    }

    public static List<X509Certificate> getCertList() {
        return certList;
    }

    public static KeyPair getSigningKP() {
        return signingKP;
    }

    static {
        serialNo = 1;
    }
}

