/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.as2.it;

import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.component.as2.api.AS2EncryptionAlgorithm;
import org.apache.camel.component.as2.api.AS2MessageStructure;
import org.apache.camel.component.as2.api.AS2SignatureAlgorithm;
import org.apache.camel.quarkus.component.as2.it.transport.Request;
import org.apache.http.entity.ContentType;

public class As2Helper {
    public static final String AS2_VERSION = "1.1";
    public static final String REQUEST_URI = "/";
    public static final String SUBJECT = "Test Case";
    public static final String AS2_NAME = "878051556";
    public static final String FROM = "mrAS@example.org";
    public static final String[] SIGNED_RECEIPT_MIC_ALGORITHMS = new String[]{"sha1", "md5"};
    public static final String DISPOSITION_NOTIFICATION_TO = "mrAS@example.org";
    public static final String EDI_MESSAGE = "UNB+UNOA:1+005435656:1+006415160:1+060515:1434+00000000000778'\nUNH+00000000000117+INVOIC:D:97B:UN'\nBGM+380+342459+9'\nDTM+3:20060515:102'\nRFF+ON:521052'\nNAD+BY+792820524::16++CUMMINS MID-RANGE ENGINE PLANT'\nNAD+SE+005435656::16++GENERAL WIDGET COMPANY'\nCUX+1:USD'\nLIN+1++157870:IN'\nIMD+F++:::WIDGET'\nQTY+47:1020:EA'\nALI+US'\nMOA+203:1202.58'\nPRI+INV:1.179'\nLIN+2++157871:IN'\nIMD+F++:::DIFFERENT WIDGET'\nQTY+47:20:EA'\nALI+JP'\nMOA+203:410'\nPRI+INV:20.5'\nUNS+S'\nMOA+39:2137.58'\nALC+C+ABG'\nMOA+8:525'\nUNT+23+00000000000117'\nUNZ+1+00000000000778'";
    private static final String EDI_MESSAGE_CONTENT_TRANSFER_ENCODING = "7bit";

    private As2Helper() {
    }

    public static Request createPlainRequest() {
        Map<String, Object> headers = As2Helper.createBaseHeaders(AS2MessageStructure.PLAIN);
        return new Request().withHeaders(headers).withEdiMessage(EDI_MESSAGE);
    }

    public static Request createEncryptedRequest() {
        Map<String, Object> headers = As2Helper.createBaseHeaders(AS2MessageStructure.ENCRYPTED);
        return new Request().withHeaders(headers).withEdiMessage(EDI_MESSAGE).withEncryptionAlgorithm(AS2EncryptionAlgorithm.AES128_CBC);
    }

    public static Request createMultipartSignedRequest() {
        Map<String, Object> headers = As2Helper.createBaseHeaders(AS2MessageStructure.SIGNED);
        headers.put("CamelAS2.signedReceiptMicAlgorithms", SIGNED_RECEIPT_MIC_ALGORITHMS);
        return new Request().withHeaders(headers).withEdiMessage(EDI_MESSAGE).withSigningAlgorithm(AS2SignatureAlgorithm.SHA512WITHRSA);
    }

    private static Map<String, Object> createBaseHeaders(AS2MessageStructure plain) {
        HashMap<String, Object> headers = new HashMap<String, Object>();
        headers.put("CamelAS2.requestUri", REQUEST_URI);
        headers.put("CamelAS2.subject", SUBJECT);
        headers.put("CamelAS2.from", "mrAS@example.org");
        headers.put("CamelAS2.as2From", AS2_NAME);
        headers.put("CamelAS2.as2To", AS2_NAME);
        headers.put("CamelAS2.as2MessageStructure", plain);
        headers.put("CamelAS2.ediMessageContentType", ContentType.create((String)"application/edifact", (String)StandardCharsets.US_ASCII.name()));
        headers.put("CamelAS2.ediMessageTransferEncoding", EDI_MESSAGE_CONTENT_TRANSFER_ENCODING);
        headers.put("CamelAS2.dispositionNotificationTo", "mrAS@example.org");
        return headers;
    }
}

