/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.quarkus.component.as2.it;

import io.quarkus.test.common.QuarkusTestResource;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.camel.component.as2.api.entity.AS2MessageDispositionNotificationEntity;
import org.apache.camel.quarkus.component.as2.it.As2Helper;
import org.apache.camel.quarkus.component.as2.it.As2Receiver;
import org.apache.camel.quarkus.component.as2.it.As2Resource;
import org.apache.camel.quarkus.component.as2.it.As2Sender;
import org.apache.camel.quarkus.component.as2.it.As2TestResource;
import org.apache.camel.quarkus.component.as2.it.transport.ClientResult;
import org.apache.camel.quarkus.component.as2.it.transport.Request;
import org.apache.camel.quarkus.component.as2.it.transport.ServerResult;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.config.ConfigProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@QuarkusTestResource(value=As2TestResource.class)
@QuarkusTest
public class As2Test {
    private static final Logger LOG = LoggerFactory.getLogger(As2Test.class);

    @Test
    public void serverPlainTest() throws Exception {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        Future<Boolean> initResult = executor.submit(() -> (Boolean)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/as2/serverInit", new Object[0])).then()).statusCode(200)).extract().as(Boolean.class));
        Awaitility.await().atMost(5L, TimeUnit.SECONDS).untilAsserted(() -> Assertions.assertTrue((boolean)((Boolean)initResult.get())));
        Future<ServerResult> futureResult = executor.submit(() -> (ServerResult)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().get("/as2/server", new Object[0])).then()).statusCode(200)).extract().as(ServerResult.class));
        As2Sender.As2SenderClient client = As2Sender.createClient((Integer)ConfigProvider.getConfig().getValue(As2Resource.SERVER_PORT_PARAMETER, Integer.class));
        client.sendMessage("UNB+UNOA:1+005435656:1+006415160:1+060515:1434+00000000000778'\nUNH+00000000000117+INVOIC:D:97B:UN'\nBGM+380+342459+9'\nDTM+3:20060515:102'\nRFF+ON:521052'\nNAD+BY+792820524::16++CUMMINS MID-RANGE ENGINE PLANT'\nNAD+SE+005435656::16++GENERAL WIDGET COMPANY'\nCUX+1:USD'\nLIN+1++157870:IN'\nIMD+F++:::WIDGET'\nQTY+47:1020:EA'\nALI+US'\nMOA+203:1202.58'\nPRI+INV:1.179'\nLIN+2++157871:IN'\nIMD+F++:::DIFFERENT WIDGET'\nQTY+47:20:EA'\nALI+JP'\nMOA+203:410'\nPRI+INV:20.5'\nUNS+S'\nMOA+39:2137.58'\nALC+C+ABG'\nMOA+8:525'\nUNT+23+00000000000117'\nUNZ+1+00000000000778'");
        Awaitility.await().atMost(10L, TimeUnit.SECONDS).untilAsserted(() -> {
            ServerResult result = (ServerResult)futureResult.get();
            Assertions.assertEquals((Object)"UNB+UNOA:1+005435656:1+006415160:1+060515:1434+00000000000778'\nUNH+00000000000117+INVOIC:D:97B:UN'\nBGM+380+342459+9'\nDTM+3:20060515:102'\nRFF+ON:521052'\nNAD+BY+792820524::16++CUMMINS MID-RANGE ENGINE PLANT'\nNAD+SE+005435656::16++GENERAL WIDGET COMPANY'\nCUX+1:USD'\nLIN+1++157870:IN'\nIMD+F++:::WIDGET'\nQTY+47:1020:EA'\nALI+US'\nMOA+203:1202.58'\nPRI+INV:1.179'\nLIN+2++157871:IN'\nIMD+F++:::DIFFERENT WIDGET'\nQTY+47:20:EA'\nALI+JP'\nMOA+203:410'\nPRI+INV:20.5'\nUNS+S'\nMOA+39:2137.58'\nALC+C+ABG'\nMOA+8:525'\nUNT+23+00000000000117'\nUNZ+1+00000000000778'".replaceAll("[\n\r]", ""), (Object)result.getResult().replaceAll("[\n\r]", ""), (String)"Unexpected content for enveloped mime part");
            Assertions.assertEquals((Object)BasicHttpEntityEnclosingRequest.class.getSimpleName(), (Object)result.getRequestClass(), (String)"Request does not contain entity");
        });
    }

    @Test
    public void clientPlainTest() throws Exception {
        this.clientTest(As2Helper.createPlainRequest());
    }

    @Test
    public void clientEncryptionTest() throws Exception {
        this.clientTest(As2Helper.createEncryptedRequest());
    }

    @Test
    public void clientMultipartSignedTest() throws Exception {
        ClientResult clientResult = this.clientTest(As2Helper.createMultipartSignedRequest());
        Assertions.assertTrue((boolean)clientResult.isSignedEntityReceived(), (String)"Signature Entity");
    }

    private ClientResult clientTest(Request request) throws Exception {
        As2Receiver.RequestHandler requestHandler = As2Receiver.startReceiver((Integer)ConfigProvider.getConfig().getValue(As2Resource.CLIENT_PORT_PARAMETER, Integer.class));
        ClientResult clientResult = (ClientResult)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().contentType(ContentType.JSON).body((Object)request).post("/as2/client", new Object[0])).then()).statusCode(200)).extract().body().as(ClientResult.class);
        Assertions.assertNotNull((Object)clientResult, (String)"Response entity");
        Assertions.assertEquals((int)2, (int)clientResult.getPartsCount(), (String)"Unexpected number of body parts in report");
        Assertions.assertEquals((Object)AS2MessageDispositionNotificationEntity.class.getSimpleName(), (Object)clientResult.getSecondPartClassName(), (String)"Unexpected type of As2Entity");
        Assertions.assertNotNull((Object)requestHandler.getRequest(), (String)"Request");
        Assertions.assertNotNull((Object)requestHandler.getResponse(), (String)"Response");
        return clientResult;
    }
}

